% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FUN.R
\name{calibrate_window}
\alias{calibrate_window}
\title{calibrate the time window of a list of xts objects}
\usage{
calibrate_window(list, FUN, ...)
}
\arguments{
\item{list}{A list of xts objects.}

\item{FUN}{A function applied to each element of the
list}

\item{...}{optional arguments passed to \code{FUN}.}
}
\value{
Returns a xts object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function is a high-level wrapper of \link{do.call} and \link{lapply} which
modifies each xts object stored in a \code{\link[=list]{list()}}.
}
\examples{
# script start;

# 1) check index of BTCUSDT and
# the Fear and Greed Index
setequal(
  zoo::index(BTC),
  zoo::index(FGIndex)
)

# 2) to align the indices,
# we use the convincience functions
# by splitting the FGI by the BTC index.
FGIndex <- cryptoQuotes::split_window(
  xts = cryptoQuotes::FGIndex,
  by  = zoo::index(BTC),

  # Remove upper bounds of the
  # index to avoid overlap between
  # the dates.
  #
  # This ensures that the FGI is split
  # according to start of each weekly
  # BTC candle
  bounds = 'upper'
)

# 3) as splitWindow returns a list
# it needs to passed into calibrateWindow
# to ensure comparability
FGIndex <- cryptoQuotes::calibrate_window(
  list = FGIndex,

  # As each element in the list can include
  # more than one row, each element needs to be aggregated
  # or summarised.
  #
  # using xts::first gives the first element
  # of each list, along with its values
  FUN  = xts::first
)


# 3) check if candles aligns
# accordingly
stopifnot(
  setequal(
    zoo::index(BTC),
    zoo::index(FGIndex)
  )
)


# script end;
}
\seealso{
Other utility: 
\code{\link{remove_bound}()},
\code{\link{split_window}()},
\code{\link{write_xts}()}
}
\concept{utility}
