% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_CDC_wallet.R
\name{format_CDC_wallet}
\alias{format_CDC_wallet}
\title{Format CDC wallet file}
\usage{
format_CDC_wallet(data, list.prices = NULL, force = FALSE)
}
\arguments{
\item{data}{The dataframe}

\item{list.prices}{A \code{list.prices} object from which to fetch coin prices.}

\item{force}{Whether to force recreating \code{list.prices} even though
it already exists (e.g., if you added new coins or new dates).}
}
\value{
A data frame of exchange transactions, formatted for further processing.
}
\description{
Format a .csv transaction history file from the Crypto.com DeFi
wallet for later ACB processing.

One way to download the CRO staking rewards data from the blockchain is to
visit http://crypto.barkisoft.de/ and input your CRO address. Keep the default
export option ("Koinly"). It will output a CSV file with your transactions.
Note: the site does not use a secure connection: use at your own risks.
The file is semi-column separated; when using \code{read.csv}, add the \code{sep = ";"}
argument.
}
\examples{
format_CDC_wallet(data_CDC_wallet)
}
