/*
 * Decompiled with CFR 0.152.
 */
package org.libtiff.jai.codec;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import javax.media.jai.JAI;
import javax.media.jai.RasterFactory;
import org.libtiff.jai.codec.XTIFFDecodeParam;
import org.libtiff.jai.codec.XTIFFDirectory;
import org.libtiff.jai.codec.XTIFFEncodeParam;
import org.libtiff.jai.codec.XTIFFField;
import org.libtiff.jai.codec.XTIFFTileCodec;
import org.libtiff.jai.util.JaiI18N;

public abstract class XTIFFTileCodecImpl
implements XTIFFTileCodec {
    protected XTIFFDirectory directory = null;
    protected RenderedImage image = null;
    protected int minY;
    protected int minX;
    protected int width;
    protected int length;
    protected int numBands;
    protected int tileLength;
    protected int tileWidth;
    protected int compression;
    protected SampleModel sampleModel;
    protected int[] sampleSize;
    protected char[] bitsPerSample;
    protected char[] colormap = null;
    protected XTIFFEncodeParam encodeParam = null;
    private int[] _pixels;
    protected boolean isTiled;
    protected XTIFFDecodeParam decodeParam = null;
    protected boolean decodePaletteAsShorts = false;
    protected int unitsInThisTile;
    protected byte[] _bdata = null;
    protected short[] _sdata = null;
    protected byte[] bpixvals = null;
    protected short[] spixvals = null;
    protected DataBuffer buffer = null;
    protected int dataType;
    protected int image_type;

    public abstract void register();

    public abstract XTIFFTileCodec create();

    public boolean canEncode() {
        return false;
    }

    public void initializeDecoding() {
    }

    public void initializeEncoding() {
    }

    public abstract void decodeTilePixels(byte[] var1, Rectangle var2, byte[] var3);

    public abstract void decodeTilePixels(byte[] var1, Rectangle var2, short[] var3);

    public int encodeTilePixels(int[] pixels, Rectangle rect, byte[] bpixels) {
        return 0;
    }

    public void initialize() {
        XTIFFField bitsField;
        this.width = (int)this.getLongField(256);
        this.length = (int)this.getLongField(257);
        this.isTiled = this.directory.isTiled();
        if (this.isTiled) {
            this.tileWidth = (int)this.getLongField(322);
            this.tileLength = (int)this.getLongField(323);
        } else {
            this.tileWidth = this.width;
            this.tileLength = (int)this.getLongField(278);
        }
        XTIFFField compField = this.directory.getField(259);
        this.compression = compField != null ? compField.getAsInt(0) : 1;
        XTIFFField cfield = this.directory.getField(320);
        if (cfield != null) {
            this.colormap = cfield.getAsChars();
        }
        if ((bitsField = this.directory.getField(258)) == null) {
            this.bitsPerSample = new char[1];
            this.bitsPerSample[0] = '\u0001';
        } else {
            this.bitsPerSample = bitsField.getAsChars();
        }
        this.image_type = this.directory.getImageType();
    }

    protected long getLongField(int fld) {
        XTIFFField field = this.directory.getField(fld);
        if (field == null) {
            return 0L;
        }
        return field.getAsLong(0);
    }

    public void register(int comp) {
        XTIFFDirectory.registerTileCodec(comp, this);
    }

    protected void setupSourceImage(RenderedImage img) {
        this.image = img;
        this.minY = this.image.getMinY();
        this.minX = this.image.getMinX();
        this.sampleModel = this.image.getSampleModel();
        this.numBands = this.sampleModel.getNumBands();
        this.sampleSize = this.sampleModel.getSampleSize();
    }

    public int getCompression() {
        return this.compression;
    }

    public XTIFFTileCodec create(XTIFFEncodeParam param) throws IOException {
        XTIFFTileCodecImpl codec = (XTIFFTileCodecImpl)this.create();
        codec.initialize(param);
        return codec;
    }

    protected void initialize(XTIFFEncodeParam param) throws IOException {
        if (!this.canEncode()) {
            throw new IOException("encoding not supported");
        }
        this.encodeParam = param;
        this.directory = param.getDirectory();
        this.initialize();
        this.initializeEncoding();
    }

    public int encode(RenderedImage img, Rectangle rect, byte[] bpixels) {
        if (this.image == null) {
            this.setupSourceImage(img);
            this.setupBufferForEncoding();
        }
        this.getTilePixels(rect);
        return this.encodeTilePixels(this._pixels, rect, bpixels);
    }

    protected void setupBufferForEncoding() {
        this._pixels = new int[this.tileWidth * this.tileLength * this.numBands];
        int padRight = (this.tileWidth - this.width % this.tileWidth) % this.tileWidth;
        int padBottom = (this.tileLength - this.length % this.tileLength) % this.tileLength;
        if (!this.isTiled) {
            padBottom = 0;
        }
        if (padRight > 0 || padBottom > 0) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.image);
            pb.add(null).add(padRight).add(null).add(padBottom).add(null).add(null);
            this.image = JAI.create((String)"border", (ParameterBlock)pb);
        }
    }

    protected void getTilePixels(Rectangle rect) {
        Raster src = this.image.getData(rect);
        int col = (int)rect.getX();
        int row = (int)rect.getY();
        int rows = (int)rect.getHeight();
        int cols = (int)rect.getWidth();
        src.getPixels(col, row, cols, rows, this._pixels);
    }

    public int getCompressedTileSize(RenderedImage im) {
        this.sampleModel = im.getSampleModel();
        this.numBands = this.sampleModel.getNumBands();
        this.sampleSize = this.sampleModel.getSampleSize();
        return (int)Math.ceil((double)(2 * this.tileWidth * this.tileLength * this.numBands) * ((double)this.sampleSize[0] / 8.0));
    }

    public XTIFFTileCodec create(XTIFFDecodeParam param) throws IOException {
        XTIFFTileCodecImpl codec = (XTIFFTileCodecImpl)this.create();
        codec.initialize(param);
        return codec;
    }

    protected void initialize(XTIFFDecodeParam param) throws IOException {
        this.decodeParam = param;
        this.decodePaletteAsShorts = param.getDecodePaletteAsShorts();
        this.directory = param.getDirectory();
        this.initialize();
        this.initializeDecoding();
    }

    protected void setupBufferForDecoding() {
        this.buffer = this.sampleModel.createDataBuffer();
        this.dataType = this.sampleModel.getDataType();
        if (this.dataType == 0) {
            this._bdata = ((DataBufferByte)this.buffer).getData();
            this.bpixvals = this._bdata;
        } else if (this.dataType == 1) {
            this._sdata = ((DataBufferUShort)this.buffer).getData();
            if (!this.decodePaletteAsShorts) {
                this.spixvals = this._sdata;
            }
        } else if (this.dataType == 2) {
            this._sdata = ((DataBufferShort)this.buffer).getData();
            if (!this.decodePaletteAsShorts) {
                this.spixvals = this._sdata;
            }
        }
        if (this.decodePaletteAsShorts) {
            int len = this._sdata.length;
            if (this.bitsPerSample[0] == '\u0010') {
                this.spixvals = new short[len];
            } else {
                this.bpixvals = new byte[len];
            }
        }
    }

    public WritableRaster decode(RenderedImage img, Rectangle newRect, byte[] bpixels) {
        if (this.image == null) {
            this.setupSourceImage(img);
        }
        this.setupBufferForDecoding();
        this.unitsInThisTile = newRect.width * newRect.height * this.numBands;
        this.decodeTilePixels(bpixels, newRect);
        this.decodeColor(newRect);
        return this.setTilePixels(newRect);
    }

    protected void decodeColor(Rectangle newRect) {
        switch (this.dataType) {
            case 0: {
                this.decodeColor(this.bpixvals, this._bdata, newRect);
                break;
            }
            case 1: 
            case 2: {
                if (this.bpixvals != null) {
                    this.decodeColor(this.bpixvals, this._sdata, newRect);
                    break;
                }
                this.decodeColor(this.spixvals, this._sdata, newRect);
            }
        }
    }

    protected void decodeTilePixels(byte[] bpixels, Rectangle newRect) {
        if (this.bpixvals != null) {
            this.decodeTilePixels(bpixels, newRect, this.bpixvals);
        } else {
            this.decodeTilePixels(bpixels, newRect, this.spixvals);
        }
    }

    protected WritableRaster setTilePixels(Rectangle rect) {
        return RasterFactory.createWritableRaster((SampleModel)this.sampleModel, (DataBuffer)this.buffer, (Point)new Point((int)rect.getX(), (int)rect.getY()));
    }

    protected void unpackShorts(byte[] byteArray, short[] output, int shortCount) {
        if (this.directory.isBigEndian()) {
            for (int i = 0; i < shortCount; ++i) {
                int j = 2 * i;
                int firstByte = byteArray[j] & 0xFF;
                int secondByte = byteArray[j + 1] & 0xFF;
                output[i] = (short)((firstByte << 8) + secondByte);
            }
        } else {
            for (int i = 0; i < shortCount; ++i) {
                int j = 2 * i;
                int firstByte = byteArray[j] & 0xFF;
                int secondByte = byteArray[j + 1] & 0xFF;
                output[i] = (short)((secondByte << 8) + firstByte);
            }
        }
    }

    protected void decodeColor(byte[] bpix, short[] sdata, Rectangle newRect) {
        switch (this.image_type) {
            case 9: {
                if (this.bitsPerSample[0] == '\b') {
                    int unitsBeforeLookup = this.unitsInThisTile / 3;
                    int count = 0;
                    int len = this.colormap.length / 3;
                    int len2 = len * 2;
                    for (int i = 0; i < unitsBeforeLookup; ++i) {
                        int lookup = bpix[i] & 0xFF;
                        char cmapValue = this.colormap[lookup + len2];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                        cmapValue = this.colormap[lookup + len];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                        cmapValue = this.colormap[lookup];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                    }
                    break;
                }
                if (this.bitsPerSample[0] == '\u0004') {
                    int padding = newRect.width % 2;
                    int bytesPostDecoding = (newRect.width + 1) / 2 * newRect.height;
                    int bytes = this.unitsInThisTile / 3;
                    byte[] data = new byte[bytes];
                    int srcCount = 0;
                    int dstCount = 0;
                    for (int j = 0; j < newRect.height; ++j) {
                        for (int i = 0; i < newRect.width / 2; ++i) {
                            data[dstCount++] = (byte)((bpix[srcCount] & 0xF0) >> 4);
                            data[dstCount++] = (byte)(bpix[srcCount++] & 0xF);
                        }
                        if (padding != 1) continue;
                        data[dstCount++] = (byte)((bpix[srcCount++] & 0xF0) >> 4);
                    }
                    int len = this.colormap.length / 3;
                    int len2 = len * 2;
                    int count = 0;
                    for (int i = 0; i < bytes; ++i) {
                        int lookup = data[i] & 0xFF;
                        char cmapValue = this.colormap[lookup + len2];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                        cmapValue = this.colormap[lookup + len];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                        cmapValue = this.colormap[lookup];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                    }
                    break;
                }
                throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder7"));
            }
        }
    }

    protected void decodeColor(short[] spix, short[] sdata, Rectangle newRect) {
        switch (this.image_type) {
            case 2: 
            case 3: {
                if (this.image_type != 2) break;
                if (this.dataType == 1) {
                    for (int l = 0; l < sdata.length; ++l) {
                        sdata[l] = (short)(65535 - spix[l]);
                    }
                } else {
                    if (this.dataType != 2) break;
                    for (int l = 0; l < sdata.length; ++l) {
                        sdata[l] = ~spix[l];
                    }
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.unitsInThisTile; i += 3) {
                    short sswap = spix[i];
                    sdata[i] = spix[i + 2];
                    sdata[i + 2] = sswap;
                }
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                for (int i = 0; i < this.unitsInThisTile; i += 4) {
                    short sswap = spix[i];
                    sdata[i] = spix[i + 3];
                    sdata[i + 3] = sswap;
                    sswap = spix[i + 1];
                    sdata[i + 1] = spix[i + 2];
                    sdata[i + 2] = sswap;
                }
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                if (!this.decodePaletteAsShorts) break;
                int unitsBeforeLookup = this.unitsInThisTile / 3;
                int entries = unitsBeforeLookup * 2;
                if (this.dataType == 1) {
                    int count = 0;
                    int len = this.colormap.length / 3;
                    int len2 = len * 2;
                    for (int i = 0; i < unitsBeforeLookup; ++i) {
                        int lookup = spix[i] & 0xFFFF;
                        char cmapValue = this.colormap[lookup + len2];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                        cmapValue = this.colormap[lookup + len];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                        cmapValue = this.colormap[lookup];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                    }
                } else {
                    if (this.dataType != 2) break;
                    int count = 0;
                    int len = this.colormap.length / 3;
                    int len2 = len * 2;
                    for (int i = 0; i < unitsBeforeLookup; ++i) {
                        int lookup = spix[i] & 0xFFFF;
                        char cmapValue = this.colormap[lookup + len2];
                        sdata[count++] = (short)cmapValue;
                        cmapValue = this.colormap[lookup + len];
                        sdata[count++] = (short)cmapValue;
                        cmapValue = this.colormap[lookup];
                        sdata[count++] = (short)cmapValue;
                    }
                }
                break;
            }
        }
    }

    protected void decodeColor(byte[] bpix, byte[] bdata, Rectangle newRect) {
        switch (this.image_type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                if (this.bitsPerSample[0] != '\b') break;
                for (int i = 0; i < this.unitsInThisTile; i += 3) {
                    byte bswap = bpix[i];
                    bdata[i] = bpix[i + 2];
                    bdata[i + 2] = bswap;
                }
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if (this.bitsPerSample[0] != '\b') break;
                for (int i = 0; i < this.unitsInThisTile; i += 4) {
                    byte bswap = bpix[i];
                    bdata[i] = bpix[i + 3];
                    bdata[i + 3] = bswap;
                    bswap = bpix[i + 1];
                    bdata[i + 1] = bpix[i + 2];
                    bdata[i + 2] = bswap;
                }
                break;
            }
        }
    }
}

