/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import java.io.Serializable;

public class LineSegment
implements Comparable,
Serializable {
    private static final long serialVersionUID = 3252005833466256227L;
    public Coordinate p0;
    public Coordinate p1;

    public LineSegment(Coordinate p0, Coordinate p1) {
        this.p0 = p0;
        this.p1 = p1;
    }

    public LineSegment(LineSegment ls) {
        this(ls.p0, ls.p1);
    }

    public LineSegment() {
        this(new Coordinate(), new Coordinate());
    }

    public Coordinate getCoordinate(int i) {
        if (i == 0) {
            return this.p0;
        }
        return this.p1;
    }

    public void setCoordinates(LineSegment ls) {
        this.setCoordinates(ls.p0, ls.p1);
    }

    public void setCoordinates(Coordinate p0, Coordinate p1) {
        this.p0.x = p0.x;
        this.p0.y = p0.y;
        this.p1.x = p1.x;
        this.p1.y = p1.y;
    }

    public double getLength() {
        return this.p0.distance(this.p1);
    }

    public boolean isHorizontal() {
        return this.p0.y == this.p1.y;
    }

    public boolean isVertical() {
        return this.p0.x == this.p1.x;
    }

    public int orientationIndex(LineSegment seg) {
        int orient0 = CGAlgorithms.orientationIndex(this.p0, this.p1, seg.p0);
        int orient1 = CGAlgorithms.orientationIndex(this.p0, this.p1, seg.p1);
        if (orient0 >= 0 && orient1 >= 0) {
            return Math.max(orient0, orient1);
        }
        if (orient0 <= 0 && orient1 <= 0) {
            return Math.max(orient0, orient1);
        }
        return 0;
    }

    public void reverse() {
        Coordinate temp = this.p0;
        this.p0 = this.p1;
        this.p1 = temp;
    }

    public void normalize() {
        if (this.p1.compareTo(this.p0) < 0) {
            this.reverse();
        }
    }

    public double angle() {
        return Math.atan2(this.p1.y - this.p0.y, this.p1.x - this.p0.x);
    }

    public double distance(LineSegment ls) {
        return CGAlgorithms.distanceLineLine(this.p0, this.p1, ls.p0, ls.p1);
    }

    public double distance(Coordinate p) {
        return CGAlgorithms.distancePointLine(p, this.p0, this.p1);
    }

    public double distancePerpendicular(Coordinate p) {
        return CGAlgorithms.distancePointLinePerpendicular(p, this.p0, this.p1);
    }

    public Coordinate pointAlong(double segmentLengthFraction) {
        Coordinate coord = new Coordinate();
        coord.x = this.p0.x + segmentLengthFraction * (this.p1.x - this.p0.x);
        coord.y = this.p0.y + segmentLengthFraction * (this.p1.y - this.p0.y);
        return coord;
    }

    public double projectionFactor(Coordinate p) {
        if (p.equals(this.p0)) {
            return 0.0;
        }
        if (p.equals(this.p1)) {
            return 1.0;
        }
        double dx = this.p1.x - this.p0.x;
        double dy = this.p1.y - this.p0.y;
        double len2 = dx * dx + dy * dy;
        double r = ((p.x - this.p0.x) * dx + (p.y - this.p0.y) * dy) / len2;
        return r;
    }

    public Coordinate project(Coordinate p) {
        if (p.equals(this.p0) || p.equals(this.p1)) {
            return new Coordinate(p);
        }
        double r = this.projectionFactor(p);
        Coordinate coord = new Coordinate();
        coord.x = this.p0.x + r * (this.p1.x - this.p0.x);
        coord.y = this.p0.y + r * (this.p1.y - this.p0.y);
        return coord;
    }

    public LineSegment project(LineSegment seg) {
        double pf0 = this.projectionFactor(seg.p0);
        double pf1 = this.projectionFactor(seg.p1);
        if (pf0 >= 1.0 && pf1 >= 1.0) {
            return null;
        }
        if (pf0 <= 0.0 && pf1 <= 0.0) {
            return null;
        }
        Coordinate newp0 = this.project(seg.p0);
        if (pf0 < 0.0) {
            newp0 = this.p0;
        }
        if (pf0 > 1.0) {
            newp0 = this.p1;
        }
        Coordinate newp1 = this.project(seg.p1);
        if (pf1 < 0.0) {
            newp1 = this.p0;
        }
        if (pf1 > 1.0) {
            newp1 = this.p1;
        }
        return new LineSegment(newp0, newp1);
    }

    public Coordinate closestPoint(Coordinate p) {
        double dist1;
        double factor = this.projectionFactor(p);
        if (factor > 0.0 && factor < 1.0) {
            return this.project(p);
        }
        double dist0 = this.p0.distance(p);
        if (dist0 < (dist1 = this.p1.distance(p))) {
            return this.p0;
        }
        return this.p1;
    }

    public Coordinate[] closestPoints(LineSegment line) {
        Coordinate close11;
        Coordinate close10;
        Coordinate intPt = this.intersection(line);
        if (intPt != null) {
            return new Coordinate[]{intPt, intPt};
        }
        Coordinate[] closestPt = new Coordinate[2];
        double minDistance = Double.MAX_VALUE;
        Coordinate close00 = this.closestPoint(line.p0);
        minDistance = close00.distance(line.p0);
        closestPt[0] = close00;
        closestPt[1] = line.p0;
        Coordinate close01 = this.closestPoint(line.p1);
        double dist = close01.distance(line.p1);
        if (dist < minDistance) {
            minDistance = dist;
            closestPt[0] = close01;
            closestPt[1] = line.p1;
        }
        if ((dist = (close10 = line.closestPoint(this.p0)).distance(this.p0)) < minDistance) {
            minDistance = dist;
            closestPt[0] = this.p0;
            closestPt[1] = close10;
        }
        if ((dist = (close11 = line.closestPoint(this.p1)).distance(this.p1)) < minDistance) {
            minDistance = dist;
            closestPt[0] = this.p1;
            closestPt[1] = close11;
        }
        return closestPt;
    }

    public Coordinate intersection(LineSegment line) {
        RobustLineIntersector li = new RobustLineIntersector();
        li.computeIntersection(this.p0, this.p1, line.p0, line.p1);
        if (li.hasIntersection()) {
            return li.getIntersection(0);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LineSegment)) {
            return false;
        }
        LineSegment other = (LineSegment)o;
        return this.p0.equals(other.p0) && this.p1.equals(other.p1);
    }

    public int compareTo(Object o) {
        LineSegment other = (LineSegment)o;
        int comp0 = this.p0.compareTo(other.p0);
        if (comp0 != 0) {
            return comp0;
        }
        return this.p1.compareTo(other.p1);
    }

    public boolean equalsTopo(LineSegment other) {
        return this.p0.equals(other.p0) && this.p1.equals(other.p1) || this.p0.equals(other.p1) && this.p1.equals(other.p0);
    }

    public String toString() {
        return "LINESTRING( " + this.p0.x + " " + this.p0.y + ", " + this.p1.x + " " + this.p1.y + ")";
    }
}

