/*
 * Decompiled with CFR 0.152.
 */
package org.libtiff.jai.codecimpl;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codecimpl.TIFFImageEncoder;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.libtiff.jai.codec.XTIFFDirectory;
import org.libtiff.jai.codec.XTIFFEncodeParam;
import org.libtiff.jai.codec.XTIFFField;
import org.libtiff.jai.codec.XTIFFTileCodec;
import org.libtiff.jai.util.JaiI18N;

public class XTIFFImageEncoder
extends TIFFImageEncoder {
    long firstIFDOffset = 0L;
    XTIFFDirectory directory;
    XTIFFEncodeParam tparam;
    int width;
    int length;
    SampleModel sampleModel;
    int numBands;
    int[] sampleSize;
    int dataType;
    boolean dataTypeIsShort;
    ColorModel colorModel;
    int numTiles;
    int compression;
    boolean isTiled;
    long tileLength;
    long tileWidth;
    byte[] bpixels = null;
    long[] stripTileByteCounts;
    long[] stripTileOffsets;
    long currentOffset = 0L;
    public static final int XTIFF_BILEVEL_WHITE_IS_ZERO = 0;
    public static final int XTIFF_BILEVEL_BLACK_IS_ZERO = 1;
    public static final int XTIFF_PALETTE = 2;
    public static final int XTIFF_FULLCOLOR = 3;
    public static final int XTIFF_GREYSCALE = 4;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    public XTIFFImageEncoder(OutputStream output, ImageEncodeParam param) {
        super(output, param);
        if (this.param == null || !(param instanceof XTIFFEncodeParam)) {
            this.param = new XTIFFEncodeParam((TIFFEncodeParam)param);
        }
        this.tparam = (XTIFFEncodeParam)this.param;
        this.directory = this.tparam.getDirectory();
    }

    private File createTemp() throws IOException {
        String tmpdir = System.getProperty("tiff.io.tmpdir");
        File file = null;
        file = tmpdir != null ? File.createTempFile("libtiff.jai.", ".dat", new File(tmpdir)) : File.createTempFile("libtiff.jai.", ".dat");
        file.deleteOnExit();
        return file;
    }

    private void copyImageData(File tmp, OutputStream out, int total) throws IOException {
        int bufsize = 1024;
        int bytes = 0;
        byte[] buf = new byte[bufsize];
        FileInputStream in = new FileInputStream(tmp);
        do {
            bytes = in.read(buf);
            out.write(buf, 0, bytes);
        } while ((total -= bytes) > 0);
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(RenderedImage im) throws IOException {
        this.compression = this.tparam.getCompression();
        this.isTiled = ((TIFFEncodeParam)this.param).getWriteTiled();
        this.getImageFields(im);
        if (this.compression == 1) {
            this.computeIFDOffset();
            this.writeFileHeader(this.firstIFDOffset);
            this.currentOffset = 8L;
            this.writeImageData(im, this.output);
            this.writeDirectory(this.directory.getFields(), 0);
        } else {
            this.currentOffset = 8L;
            File tmp = null;
            try {
                tmp = this.createTemp();
                FileOutputStream tmpOut = new FileOutputStream(tmp);
                int total = this.writeImageData(im, tmpOut);
                ((OutputStream)tmpOut).close();
                this.writeFileHeader(this.currentOffset + this.currentOffset % 2L);
                this.copyImageData(tmp, this.output, total);
                this.writeDirectory(this.directory.getFields(), 0);
            }
            finally {
                if (tmp != null) {
                    tmp.delete();
                }
            }
        }
    }

    private void computeIFDOffset() {
        long bytesPerTile;
        long bytesPerRow = (long)Math.ceil((double)this.sampleSize[0] / 8.0 * (double)this.tileWidth * (double)this.numBands);
        long lastTile = bytesPerTile = bytesPerRow * this.tileLength;
        if (!this.isTiled) {
            long lastStripRows = (long)this.length - this.tileLength * (long)(this.numTiles - 1);
            lastTile = lastStripRows * bytesPerRow;
        }
        long totalBytesOfData = bytesPerTile * (long)(this.numTiles - 1) + lastTile;
        this.firstIFDOffset = 8L + totalBytesOfData;
        if (this.firstIFDOffset % 2L != 0L) {
            ++this.firstIFDOffset;
        }
    }

    private void writeFileHeader(long firstIFDOffset) throws IOException {
        this.output.write(77);
        this.output.write(77);
        this.output.write(0);
        this.output.write(42);
        this.writeLong(firstIFDOffset);
    }

    private void addIfAbsent(int tag, int type, int count, Object obj) {
        if (this.directory.getField(tag) == null) {
            this.directory.addField(tag, type, count, obj);
        }
    }

    private void getImageFields(RenderedImage im) {
        XTIFFField fld;
        this.width = im.getWidth();
        this.length = im.getHeight();
        this.sampleModel = im.getSampleModel();
        this.numBands = this.sampleModel.getNumBands();
        this.sampleSize = this.sampleModel.getSampleSize();
        this.dataType = this.sampleModel.getDataType();
        if (this.dataType != 0 && this.dataType != 2 && this.dataType != 1) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder0"));
        }
        this.dataTypeIsShort = this.dataType == 2 || this.dataType == 1;
        this.colorModel = im.getColorModel();
        if (this.colorModel != null && this.colorModel instanceof IndexColorModel && this.dataTypeIsShort) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder2"));
        }
        IndexColorModel icm = null;
        int sizeOfColormap = 0;
        char[] colormap = null;
        int photometricInterpretation = 2;
        int imageType = 3;
        if (this.colorModel instanceof IndexColorModel) {
            icm = (IndexColorModel)this.colorModel;
            int mapSize = icm.getMapSize();
            if (this.sampleSize[0] == 1) {
                if (mapSize != 2) {
                    throw new IllegalArgumentException(JaiI18N.getString("TIFFImageEncoder1"));
                }
                byte[] r = new byte[mapSize];
                icm.getReds(r);
                byte[] g = new byte[mapSize];
                icm.getGreens(g);
                byte[] b = new byte[mapSize];
                icm.getBlues(b);
                imageType = (r[0] & 0xFF) == 0 && (r[1] & 0xFF) == 255 && (g[0] & 0xFF) == 0 && (g[1] & 0xFF) == 255 && (b[0] & 0xFF) == 0 && (b[1] & 0xFF) == 255 ? 1 : ((r[0] & 0xFF) == 255 && (r[1] & 0xFF) == 0 && (g[0] & 0xFF) == 255 && (g[1] & 0xFF) == 0 && (b[0] & 0xFF) == 255 && (b[1] & 0xFF) == 0 ? 0 : 2);
            } else {
                imageType = 2;
            }
        } else {
            imageType = (this.colorModel == null || this.colorModel.getColorSpace().getType() == 6) && this.numBands == 1 ? 4 : 3;
        }
        switch (imageType) {
            case 0: {
                photometricInterpretation = 0;
                break;
            }
            case 1: {
                photometricInterpretation = 1;
                break;
            }
            case 4: {
                photometricInterpretation = 1;
                break;
            }
            case 2: {
                photometricInterpretation = 3;
                icm = (IndexColorModel)this.colorModel;
                sizeOfColormap = icm.getMapSize();
                byte[] r = new byte[sizeOfColormap];
                icm.getReds(r);
                byte[] g = new byte[sizeOfColormap];
                icm.getGreens(g);
                byte[] b = new byte[sizeOfColormap];
                icm.getBlues(b);
                int redIndex = 0;
                int greenIndex = sizeOfColormap;
                int blueIndex = 2 * sizeOfColormap;
                colormap = new char[sizeOfColormap * 3];
                for (int i = 0; i < sizeOfColormap; ++i) {
                    colormap[redIndex++] = (char)(r[i] << 8);
                    colormap[greenIndex++] = (char)(g[i] << 8);
                    colormap[blueIndex++] = (char)(b[i] << 8);
                }
                sizeOfColormap *= 3;
                break;
            }
            case 3: {
                photometricInterpretation = 2;
            }
        }
        if (this.isTiled) {
            this.tileWidth = 16L;
            this.tileLength = 16L;
            fld = this.directory.getField(322);
            if (fld != null) {
                this.tileWidth = (int)fld.getAsLong(0);
            }
            if ((fld = this.directory.getField(323)) != null) {
                this.tileLength = (int)fld.getAsLong(0);
            }
        } else {
            this.tileLength = 8L;
            this.tileWidth = this.width;
            fld = this.directory.getField(278);
            if (fld != null) {
                this.tileLength = fld.getAsLong(0);
            }
        }
        this.numTiles = (int)Math.ceil((double)this.length / (double)this.tileLength) * (int)Math.ceil((double)this.width / (double)this.tileWidth);
        this.stripTileByteCounts = new long[this.numTiles];
        this.stripTileOffsets = new long[this.numTiles];
        this.directory.addField(256, 4, 1, new long[]{this.width});
        this.directory.addField(257, 4, 1, new long[]{this.length});
        this.directory.addField(258, 3, this.numBands, this.convertToChars(this.sampleSize));
        this.directory.addField(259, 3, 1, new char[]{(char)this.compression});
        this.directory.addField(262, 3, 1, new char[]{(char)photometricInterpretation});
        this.directory.addField(277, 3, 1, new char[]{(char)this.numBands});
        if (this.isTiled) {
            this.directory.addField(322, 4, 1, new long[]{this.tileWidth});
            this.directory.addField(323, 4, 1, new long[]{this.tileLength});
            this.directory.addField(324, 4, this.numTiles, this.stripTileOffsets);
            this.directory.addField(325, 4, this.numTiles, this.stripTileByteCounts);
        } else {
            this.directory.addField(273, 4, this.numTiles, this.stripTileOffsets);
            this.directory.addField(278, 4, 1, new long[]{this.tileLength});
            this.directory.addField(279, 4, this.numTiles, this.stripTileByteCounts);
        }
        this.addIfAbsent(282, 5, 1, new long[][]{{72L, 1L}});
        this.addIfAbsent(283, 5, 1, new long[][]{{72L, 1L}});
        this.addIfAbsent(296, 3, 1, new char[]{'\u0002'});
        if (colormap != null) {
            this.directory.addField(320, 3, sizeOfColormap, colormap);
        }
        if (this.dataTypeIsShort) {
            int[] sampleFormat = new int[this.numBands];
            sampleFormat[0] = this.dataType == 1 ? 1 : 2;
            for (int b = 1; b < this.numBands; ++b) {
                sampleFormat[b] = sampleFormat[0];
            }
            this.directory.addField(339, 3, this.numBands, this.convertToChars(sampleFormat));
            int[] minValue = new int[this.numBands];
            minValue[0] = this.dataType == 1 ? 0 : Short.MIN_VALUE;
            for (int b = 1; b < this.numBands; ++b) {
                minValue[b] = minValue[0];
            }
            this.directory.addField(340, 3, this.numBands, this.convertToChars(minValue));
            int[] maxValue = new int[this.numBands];
            maxValue[0] = this.dataType == 1 ? 65535 : Short.MAX_VALUE;
            for (int b = 1; b < this.numBands; ++b) {
                maxValue[b] = maxValue[0];
            }
            this.directory.addField(341, 3, this.numBands, this.convertToChars(maxValue));
        }
    }

    private char[] convertToChars(int[] shorts) {
        char[] out = new char[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            out[i] = (char)shorts[i];
        }
        return out;
    }

    protected int getSampleSize() {
        if (this.dataType == 0) {
            return 1;
        }
        if (this.dataTypeIsShort) {
            return 2;
        }
        return 1;
    }

    protected int getTileSize() {
        return (int)(this.tileLength * this.tileWidth * (long)this.numBands);
    }

    private int writeImageData(RenderedImage im, OutputStream out) throws IOException {
        int total = 0;
        XTIFFTileCodec codec = this.directory.createTileCodec(this.tparam);
        int tsize = codec.getCompressedTileSize(im);
        this.bpixels = new byte[tsize];
        Rectangle rect = new Rectangle();
        float minX = im.getMinX();
        float minY = im.getMinY();
        float rows = this.tileLength;
        float cols = this.tileWidth;
        int i = 0;
        int row = 0;
        while (row < this.length) {
            int col = 0;
            while (col < this.width) {
                if (!this.isTiled) {
                    rows = Math.min(this.tileLength, (long)(this.length - row));
                }
                rect.setRect(minX + (float)col, minY + (float)row, cols, rows);
                int tileSize = codec.encode(im, rect, this.bpixels);
                out.write(this.bpixels, 0, tileSize);
                this.stripTileOffsets[i] = this.currentOffset;
                this.stripTileByteCounts[i++] = tileSize;
                this.currentOffset += (long)tileSize;
                total += tileSize;
                col = (int)((long)col + this.tileWidth);
            }
            row = (int)((long)row + this.tileLength);
        }
        return total;
    }

    private void writeDirectory(XTIFFField[] fields, int nextIFDOffset) throws IOException {
        if (this.currentOffset % 2L == 1L) {
            this.output.write(0);
            ++this.currentOffset;
        }
        int numEntries = fields.length;
        long offsetBeyondIFD = this.currentOffset + (long)(12 * numEntries) + 4L + 2L;
        Vector<Integer> tooBig = new Vector<Integer>();
        this.writeUnsignedShort(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            XTIFFField field = fields[i];
            int tag = field.getTag();
            this.writeUnsignedShort(tag);
            int type = field.getType();
            this.writeUnsignedShort(type);
            int count = field.getCount();
            this.writeLong(count);
            if (count * sizeOfType[type] > 4) {
                this.writeLong(offsetBeyondIFD);
                offsetBeyondIFD += (long)(count * sizeOfType[type]);
                tooBig.add(new Integer(i));
                continue;
            }
            this.writeValuesAsFourBytes(field);
        }
        this.writeLong(nextIFDOffset);
        for (int i = 0; i < tooBig.size(); ++i) {
            int index = (Integer)tooBig.elementAt(i);
            this.writeValues(fields[index]);
        }
    }

    private void writeValuesAsFourBytes(XTIFFField field) throws IOException {
        int dataType = field.getType();
        int count = field.getCount();
        switch (dataType) {
            case 1: {
                int i;
                byte[] bytes = field.getAsBytes();
                for (i = 0; i < count; ++i) {
                    this.output.write(bytes[i]);
                }
                for (i = 0; i < 4 - count; ++i) {
                    this.output.write(0);
                }
                break;
            }
            case 3: {
                int i;
                char[] shorts = field.getAsChars();
                for (i = 0; i < count; ++i) {
                    this.writeUnsignedShort(shorts[i]);
                }
                for (i = 0; i < 2 - count; ++i) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 4: {
                long[] longs = field.getAsLongs();
                for (int i = 0; i < count; ++i) {
                    this.writeLong(longs[i]);
                }
                break;
            }
        }
    }

    private void writeValues(XTIFFField field) throws IOException {
        int dataType = field.getType();
        int count = field.getCount();
        switch (dataType) {
            case 2: {
                String[] strings = field.getAsStrings();
                for (int i = 0; i < strings.length; ++i) {
                    byte[] bytes = strings[i].getBytes();
                    for (int j = 0; j < bytes.length; ++j) {
                        this.output.write(bytes[j]);
                    }
                    if (i + 1 >= count) continue;
                    this.output.write(0);
                }
                break;
            }
            case 1: {
                byte[] bytes = field.getAsBytes();
                for (int i = 0; i < count; ++i) {
                    this.output.write(bytes[i]);
                }
                break;
            }
            case 3: {
                char[] shorts = field.getAsChars();
                for (int i = 0; i < count; ++i) {
                    this.writeUnsignedShort(shorts[i]);
                }
                break;
            }
            case 4: {
                long[] longs = field.getAsLongs();
                for (int i = 0; i < count; ++i) {
                    this.writeLong(longs[i]);
                }
                break;
            }
            case 12: {
                double[] doubles = field.getAsDoubles();
                for (int i = 0; i < count; ++i) {
                    this.writeDouble(doubles[i]);
                }
                break;
            }
            case 5: {
                long[][] rationals = field.getAsRationals();
                for (int i = 0; i < count; ++i) {
                    this.writeLong(rationals[i][0]);
                    this.writeLong(rationals[i][1]);
                }
                break;
            }
        }
    }

    private void writeUnsignedShort(int s) throws IOException {
        this.output.write((s & 0xFF00) >>> 8);
        this.output.write(s & 0xFF);
    }

    private void writeLong(long l) throws IOException {
        this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
        this.output.write((int)((l & 0xFF0000L) >>> 16));
        this.output.write((int)((l & 0xFF00L) >>> 8));
        this.output.write((int)l & 0xFF);
    }

    private void writeDouble(double d) throws IOException {
        long lval = Double.doubleToLongBits(d);
        this.writeLong(lval >>> 32);
        this.writeLong(lval & 0xFFFFFFFFFFFFFFFFL);
    }
}

