/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation;

import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class IsSimpleOp {
    public boolean isSimple(LineString geom) {
        return this.isSimpleLinearGeometry(geom);
    }

    public boolean isSimple(MultiLineString geom) {
        return this.isSimpleLinearGeometry(geom);
    }

    public boolean isSimple(MultiPoint mp) {
        if (mp.isEmpty()) {
            return true;
        }
        TreeSet<Coordinate> points = new TreeSet<Coordinate>();
        for (int i = 0; i < mp.getNumGeometries(); ++i) {
            Point pt = (Point)mp.getGeometryN(i);
            Coordinate p = pt.getCoordinate();
            if (points.contains(p)) {
                return false;
            }
            points.add(p);
        }
        return true;
    }

    private boolean isSimpleLinearGeometry(Geometry geom) {
        if (geom.isEmpty()) {
            return true;
        }
        GeometryGraph graph = new GeometryGraph(0, geom);
        RobustLineIntersector li = new RobustLineIntersector();
        SegmentIntersector si = graph.computeSelfNodes(li, true);
        if (!si.hasIntersection()) {
            return true;
        }
        if (si.hasProperIntersection()) {
            return false;
        }
        if (this.hasNonEndpointIntersection(graph)) {
            return false;
        }
        return !this.hasClosedEndpointIntersection(graph);
    }

    private boolean hasNonEndpointIntersection(GeometryGraph graph) {
        Iterator i = graph.getEdgeIterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            int maxSegmentIndex = e.getMaximumSegmentIndex();
            Iterator eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = (EdgeIntersection)eiIt.next();
                if (ei.isEndPoint(maxSegmentIndex)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasClosedEndpointIntersection(GeometryGraph graph) {
        TreeMap endPoints = new TreeMap();
        Iterator i = graph.getEdgeIterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            int maxSegmentIndex = e.getMaximumSegmentIndex();
            boolean isClosed = e.isClosed();
            Coordinate p0 = e.getCoordinate(0);
            this.addEndpoint(endPoints, p0, isClosed);
            Coordinate p1 = e.getCoordinate(e.getNumPoints() - 1);
            this.addEndpoint(endPoints, p1, isClosed);
        }
        i = endPoints.values().iterator();
        while (i.hasNext()) {
            EndpointInfo eiInfo = (EndpointInfo)i.next();
            if (!eiInfo.isClosed || eiInfo.degree == 2) continue;
            return true;
        }
        return false;
    }

    private void addEndpoint(Map endPoints, Coordinate p, boolean isClosed) {
        EndpointInfo eiInfo = (EndpointInfo)endPoints.get(p);
        if (eiInfo == null) {
            eiInfo = new EndpointInfo(p);
            endPoints.put(p, eiInfo);
        }
        eiInfo.addEndpoint(isClosed);
    }

    class EndpointInfo {
        Coordinate pt;
        boolean isClosed;
        int degree;

        EndpointInfo(Coordinate pt) {
            this.pt = pt;
            this.isClosed = false;
            this.degree = 0;
        }

        void addEndpoint(boolean isClosed) {
            ++this.degree;
            this.isClosed |= isClosed;
        }
    }
}

