/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class IndexedFeatureCollection
extends FeatureCollectionWrapper {
    private SpatialIndex spatialIndex;

    public IndexedFeatureCollection(FeatureCollection fc) {
        this(fc, (SpatialIndex)new STRtree(10));
    }

    public IndexedFeatureCollection(FeatureCollection fc, SpatialIndex spatialIndex) {
        super(fc);
        this.spatialIndex = spatialIndex;
        this.createIndex();
    }

    public void add(Feature feature) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }

    public void remove(Feature feature) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }

    public List query(Envelope env) {
        List candidate = this.spatialIndex.query(env);
        ArrayList<Feature> result = new ArrayList<Feature>();
        Iterator i = candidate.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            Geometry g = f.getGeometry();
            if (!env.intersects(g.getEnvelopeInternal())) continue;
            result.add(f);
        }
        return result;
    }

    private void createIndex() {
        int count = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            this.spatialIndex.insert(f.getGeometry().getEnvelopeInternal(), (Object)f);
            ++count;
        }
    }

    public void addAll(Collection features) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }

    public Collection remove(Envelope env) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }

    public void removeAll(Collection features) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }
}

