/*
 * Decompiled with CFR 0.152.
 */
package org.libtiff.jai.codecimpl;

import java.awt.Rectangle;
import org.libtiff.jai.codec.XTIFFField;
import org.libtiff.jai.codec.XTIFFTileCodec;
import org.libtiff.jai.codec.XTIFFTileCodecImpl;
import org.libtiff.jai.codecimpl.XTIFFFaxDecoder;

public class XTIFFFaxTileCodec
extends XTIFFTileCodecImpl {
    private XTIFFFaxDecoder decoder = null;
    long tiffT4Options;
    long tiffT6Options;
    int fillOrder;

    public XTIFFTileCodec create() {
        return new XTIFFFaxTileCodec();
    }

    public boolean canEncode() {
        return false;
    }

    public void register() {
        this.register(2);
        this.register(3);
        this.register(4);
    }

    public void initializeDecoding() {
        XTIFFField fillOrderField = this.directory.getField(266);
        this.fillOrder = fillOrderField != null ? fillOrderField.getAsInt(0) : 1;
        if (this.compression == 3) {
            XTIFFField t4OptionsField = this.directory.getField(292);
            this.tiffT4Options = t4OptionsField != null ? t4OptionsField.getAsLong(0) : 0L;
        }
        if (this.compression == 4) {
            XTIFFField t6OptionsField = this.directory.getField(293);
            this.tiffT6Options = t6OptionsField != null ? t6OptionsField.getAsLong(0) : 0L;
        }
        this.decoder = new XTIFFFaxDecoder(this.fillOrder, this.tileWidth, this.tileLength);
    }

    public void decodeTilePixels(byte[] input, Rectangle newRect, byte[] bdata) {
        if (this.compression == 2) {
            this.decoder.decode1D(bdata, input, newRect.x, newRect.height);
        } else if (this.compression == 3) {
            this.decoder.decode2D(bdata, input, newRect.x, newRect.height, this.tiffT4Options);
        } else if (this.compression == 4) {
            this.decoder.decodeT6(bdata, input, newRect.x, newRect.height, this.tiffT6Options);
        }
    }

    public void decodeTilePixels(byte[] input, Rectangle newRect, short[] sdata) {
    }
}

