/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CoordinateList
extends ArrayList {
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public CoordinateList() {
    }

    public CoordinateList(Coordinate[] coord) {
        this.add(coord, true);
    }

    public CoordinateList(Coordinate[] coord, boolean allowRepeated) {
        this.add(coord, allowRepeated);
    }

    public Coordinate getCoordinate(int i) {
        return (Coordinate)this.get(i);
    }

    public boolean add(Coordinate[] coord, boolean allowRepeated, boolean direction) {
        if (direction) {
            for (int i = 0; i < coord.length; ++i) {
                this.add(coord[i], allowRepeated);
            }
        } else {
            for (int i = coord.length - 1; i >= 0; --i) {
                this.add(coord[i], allowRepeated);
            }
        }
        return true;
    }

    public boolean add(Coordinate[] coord, boolean allowRepeated) {
        this.add(coord, allowRepeated, true);
        return true;
    }

    public boolean add(Object obj, boolean allowRepeated) {
        this.add((Coordinate)obj, allowRepeated);
        return true;
    }

    public void add(Coordinate coord, boolean allowRepeated) {
        Coordinate last;
        if (!allowRepeated && this.size() >= 1 && (last = (Coordinate)this.get(this.size() - 1)).equals2D(coord)) {
            return;
        }
        super.add(coord);
    }

    public boolean addAll(Collection coll, boolean allowRepeated) {
        boolean isChanged = false;
        Iterator i = coll.iterator();
        while (i.hasNext()) {
            this.add((Coordinate)i.next(), allowRepeated);
            isChanged = true;
        }
        return isChanged;
    }

    public void closeRing() {
        if (this.size() > 0) {
            this.add(this.get(0), false);
        }
    }

    public Coordinate[] toCoordinateArray() {
        return this.toArray(coordArrayType);
    }

    public Object clone() {
        CoordinateList clone = (CoordinateList)super.clone();
        for (int i = 0; i < this.size(); ++i) {
            clone.add(i, ((Coordinate)this.get(i)).clone());
        }
        return clone;
    }
}

