% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{as.csv.data.frame}
\alias{as.csv.data.frame}
\title{Save a Data Frame as CSV.}
\usage{
\method{as.csv}{data.frame}(x, file, na = ".", quote = FALSE,
  auto = !quote, row.names = FALSE, ...)
}
\arguments{
\item{x}{object}

\item{file}{passed to write.csv}

\item{na}{passed to write.csv}

\item{quote}{passed to write.csv}

\item{auto}{double-quote column names and row values with embedded commas or double-quotes; the latter are escaped by doubling them}

\item{row.names}{passed to write.csv}

\item{...}{passed arguments}
}
\value{
invisible data.frame (x)
}
\description{
Saves a data.frame as CSV, using selected conventions.
}
\examples{
x <- data.frame(
  check.names = FALSE,
  person = 1:3, 
  `name, suffix` = c("Bill Smith", 'Joseph "Joe" Hancock', "Mary Laguire, DDS")
)
file <- tempfile()
as.csv(x,file)
y <- as.csv(file,as.is=FALSE)
x
y
stopifnot(identical(x,y))
}
