% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_fragmentation.R
\name{analyze_fragmentation}
\alias{analyze_fragmentation}
\title{Provides fragment ends analysis}
\usage{
analyze_fragmentation(bam, targets, tag = "", window_size = 120,
  step_size = 5, min_size = 120, max_size = 180, ...)
}
\arguments{
\item{bam}{the input bam file}

\item{targets}{The targets to restrict the windows within. Must have the columns chr, start and end.
In case of whole-genome, specify full chromosomes targets.}

\item{tag}{the RG tag if the bam has more than one sample.}

\item{window_size}{The window (bin) size to use within the targets}

\item{step_size}{The step size to use in case of overlapping bins.}

\item{min_size}{Restrict fragments to this minimum size.}

\item{max_size}{Restrict fragments to this maximum size.}

\item{...}{Other parameters passed to get_fragment_size}
}
\value{
a data frame with the first three columns having the bins coordinates and
other columns having the WPS (raw and adjusted by coverage) and number of fragment ends (raw and adjusted by coverage).
}
\description{
Calculates the number of fragment ends and the Windowed Protection Score (WPS) in genomic tiles within targets
}
\details{
Fragment length will extracted from the bam file according to the parameters passed to \code{\link{get_fragment_size}}, and the number of fragment ends,
and the Windowed Protection Score (WPS) will be computed in the binned input targets. Binning is done according to the window_size and step_size parameters.

WPS is defined as the number of fragments completely spanning a window (bin) minus
the number of fragments with an endpoint within the same window as reported by Snyder et al., Cell 2016.

The output include both the fragment end counts and the WPS in their raw format as well as after adjustment by coverage in the bin.

Minimum and maximum bounds of the fragment size are applied before computing WPS and fragment ends counts.
}
\examples{
\donttest{
data("targets", package = "ctDNAtools")
bamN1 <- system.file("extdata", "N1.bam", package = "ctDNAtools")

## basic usage
analyze_fragmentation(bam = bamN1, targets = targets)

## more options
analyze_fragmentation(
  bam = bamN1, targets = targets,
  step_size = 10, window_size = 50
)
}

}
\seealso{
\code{\link{get_fragment_size}} \code{\link{bin_fragment_size}} \code{\link{summarize_fragment_size}}
}
