% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_background_panel_instance.R
\name{create_background_panel_instance}
\alias{create_background_panel_instance}
\title{Creates a background panel instance from a bam file (e.g. healthy samples)}
\usage{
create_background_panel_instance(bam, targets, reference,
  vaf_threshold = 0.05, tag = "", min_base_quality = 20,
  max_depth = 1e+05, min_mapq = 30, substitution_specific = TRUE)
}
\arguments{
\item{bam}{A character specifying the path to bam file.}

\item{targets}{The targets data frame must have the columns chr, start and end.}

\item{reference}{The reference genome as BSgenome object.}

\item{vaf_threshold}{Loci with the fraction of non-reference reads above this value are masked with NA.}

\item{tag}{The RG tag in the bam file. Empty string defaults to using the whole bam.}

\item{min_base_quality}{The minimum base quality to count a read for a loci.}

\item{max_depth}{Maximum depth for the pileup}

\item{min_mapq}{The minimum mapping quality to count a read for a loci}

\item{substitution_specific}{logical, whether to have the loci by substitutions.}
}
\value{
A named list having depth, alt and vaf data frames. Each has the same order of loci in rows and the input sample in columns.
}
\description{
This function scans the targets regions in one bam file, and reports the number of reference, non-reference reads for each loci
in addition to the non-reference (VAF) allele frequency. Loci with VAF higher than vaf_threshold are masked with NA. This function is
used internally by create_background_panel
}
\keyword{internal}
