% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cca.ct.R
\name{cca.ct}
\alias{cca.ct}
\title{Continuous-time canonical correlation analysis}
\usage{
cca.ct(fdobj1, fdobj2)
}
\arguments{
\item{fdobj1, fdobj2}{a pair of continuous-time multivariate data sets, of class \code{"\link[fda]{fd}"}}
}
\value{
A list consisting of
\item{vex1, vex2 }{matrices defining the canonical variates. The first columns of each give the coefficients defining the first pair of canonical variates; and so on.}
\item{cor }{canonical correlations, i.e., correlations between the pairs of canonical variates}
}
\description{
A continuous-time version of canonical correlation analysis (CCA).
}
\note{
Columns of the output matrix \code{vex2} are flipped as needed to ensure positive correlations.
}
\examples{


# CCA relating Canadian daily temperature and precipitation data
require(fda)
data(CanadianWeather)
daybasis <- create.bspline.basis(c(0,365), nbasis=80)
tempfd <- smooth.basis(day.5, CanadianWeather$dailyAv[,,"Temperature.C"], daybasis)$fd
precfd <- smooth.basis(day.5, CanadianWeather$dailyAv[,,"log10precip"], daybasis)$fd
tpcor <- cca.ct(tempfd, precfd)
par(mfrow=1:2)
barplot(tpcor$vex1[,1], horiz=TRUE, las=1, main="Temperature",
            sub="First canonical coefficients vector")
barplot(tpcor$vex2[,1], horiz=TRUE, las=1, main="Log precipitation",
            sub="First canonical coefficients vector")



}
\seealso{
\code{\link{cancor}}, for classical CCA
}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
}
