% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dbQueryHistory}
\alias{dbQueryHistory}
\title{Show the history of queries that were loaded into a database collection}
\usage{
dbQueryHistory(collection = "ctrdata", db = "users",
  url = "mongodb://localhost", username = "", password = "",
  verbose = FALSE)
}
\arguments{
\item{collection}{Name of collection (default is "ctrdata")}

\item{db}{Name of database (default is "users")}

\item{url}{Address of the mongodb server in mongo connection string URI format
\url{http://docs.mongodb.org/manual/reference/connection-string/} (default is
mongodb://localhost)}

\item{username}{In case access requires credentials.}

\item{password}{In case access requires credentials.}

\item{verbose}{Print information.}
}
\value{
A data frame with columns: query-timestamp, query-egister,
 query-records (note: this is the number of records loaded when last executing
 ctrLoadQueryIntoDb(), not the total record number) and query-term,
 and with one row for each ctrLoadQueryIntoDb() loading trial records
 in this collection.
}
\description{
Show the history of queries that were loaded into a database collection
}
\examples{

\dontrun{
dbQueryHistory()
}

}
