% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfName2Value.R
\name{dfName2Value}
\alias{dfName2Value}
\title{Get value for variable of interest}
\usage{
dfName2Value(df, valuename = "", wherename = "", wherevalue = "")
}
\arguments{
\item{df}{A data frame (or tibble) with four columns (`_id`,
`identifier`, `name`, `value`) as returned by \link{dfTrials2Long}}

\item{valuename}{A character string for the name of the field
that holds the value of the variable of interest
(e.g., a summary measure such as "endPoints.*tendencyValue.value")}

\item{wherename}{(optional) A character string to identify the
variable of interest among those that repeatedly occur in a
trial record (e.g., "endPoints.endPoint.title")}

\item{wherevalue}{(optional) A character string with the value of
the variable identified by `wherename` (e.g., "response")}
}
\value{
A data frame (or tibble, if \code{tibble} is loaded)
that includes the values of interest, with columns
`_id`, `identifier`, `name`, `value` and `where` (with the
contents of `wherevalue` found at `wherename`).
Contents of `value` are strings unless all its elements
are numbers. The `identifier` is generated by
function \link{dfTrials2Long} to identify matching elements,
e.g endpoint descriptions and measurements.
}
\description{
Get information for variable of interest  (e.g., clinical endpoints)
from long data frame of protocol- or result-related trial information
as returned by \link{dfTrials2Long}.
Parameters `valuename`, `wherename` and `wherevalue` are
matched using Perl regular expressions and ignoring case.
}
\examples{

dbc <- nodbi::src_sqlite(
    dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
    collection = "my_trials"
)

dfwide <- dbGetFieldsIntoDf(
    fields = c(
        ## ctgov - typical results fields
        # "clinical_results.baseline.analyzed_list.analyzed.count_list.count",
        # "clinical_results.baseline.group_list.group",
        # "clinical_results.baseline.analyzed_list.analyzed.units",
        "clinical_results.outcome_list.outcome",
        "study_design_info.allocation",
        ## euctr - typical results fields
        # "trialInformation.fullTitle",
        # "baselineCharacteristics.baselineReportingGroups.baselineReportingGroup",
        # "trialChanges.hasGlobalInterruptions",
        # "subjectAnalysisSets",
        # "adverseEvents.seriousAdverseEvents.seriousAdverseEvent",
        "endPoints.endPoint",
        "subjectDisposition.recruitmentDetails"
    ), con = dbc
)

dflong <- dfTrials2Long(df = dfwide)

## get values for the endpoint 'response'
dfName2Value(
    df = dflong,
    valuename = paste0(
        "clinical_results.*measurement.value|",
        "clinical_results.*outcome.measure.units|",
        "endPoints.endPoint.*tendencyValue.value|",
        "endPoints.endPoint.unit"
    ),
    wherename = paste0(
        "clinical_results.*outcome.measure.title|",
        "endPoints.endPoint.title"
    ),
    wherevalue = "response"
)

}
