% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctModel.R
\name{ctModel}
\alias{ctModel}
\title{Define a ctsem model}
\usage{
ctModel(n.manifest, n.latent, Tpoints, LAMBDA, manifestNames = "auto",
  latentNames = "auto", T0VAR = "auto", T0MEANS = "auto",
  MANIFESTMEANS = "auto", MANIFESTVAR = "auto", DRIFT = "auto",
  CINT = "auto", DIFFUSION = "auto", TRAITVAR = NULL,
  MANIFESTTRAITVAR = NULL, n.TDpred = 0, TDpredNames = "auto",
  TDPREDMEANS = "auto", TDPREDEFFECT = "auto", T0TDPREDCOV = "auto",
  TDPREDVAR = "auto", TRAITTDPREDCOV = "auto", TDTIPREDCOV = "auto",
  n.TIpred = 0, TIpredNames = "auto", TIPREDMEANS = "auto",
  TIPREDEFFECT = "auto", T0TIPREDEFFECT = "auto", TIPREDVAR = "auto",
  startValues = NULL)
}
\arguments{
\item{n.manifest}{Number of manifest indicators per individual at each measurement occasion / time point.
Manifest variables are included as the first element of the wide data matrix, with all the 1:n.manifest manifest variables 
at time 1 followed by those of time 2, and so on.}

\item{n.latent}{Number of latent processes.}

\item{Tpoints}{Number of time points, or measurement occasions, in the data.  This will generally be the maximum 
number of time points for a single individual, but may be one extra if sample relative time intervals are used, 
see \code{\link{ctIntervalise}}.}

\item{LAMBDA}{n.manifest*n.latent loading matrix relating latent to manifest variables, 
with latent processes 1:n.latent along the columns, and manifest variables
1:n.manifest in the rows.}

\item{manifestNames}{n.manifest length vector of manifest variable names as they appear in the data structure, 
without the _Tx time point suffix.  Defaults to Y1, Y2, etc.}

\item{latentNames}{n.latent length vector of latent variable names 
(used for naming parameters, defaults to eta1, eta2, etc).}

\item{T0VAR}{lower triangular n.latent*n.latent cholesky matrix of latent process initial variance / covariance. 
"auto" freely estimates all parameters.}

\item{T0MEANS}{n.latent*1 matrix of latent process means at first time point, T0. 
"auto" freely estimates all parameters.}

\item{MANIFESTMEANS}{n.manifest*1 matrix of manifest means.
"auto" fixes all parameters to 0, but some may need to be freed (by specifying character labels) when a process has multiple indicators.
'free' frees all parameters - identification problems may result if CINT is also free (default).}

\item{MANIFESTVAR}{lower triangular n.manifest*n.manifest cholesky matrix of variance / covariance 
between manifests at each measurement occasion (i.e. measurement error / residual).  
"auto" freely estimates variance parameters, 
and fixes covariances between manifests to 0. "free" frees all values, including covariances.}

\item{DRIFT}{n.latent*n.latent DRIFT matrix of continuous auto and cross effects, 
relating the processes over time. 
"auto" freely estimates all parameters.}

\item{CINT}{n.latent * 1 matrix of continuous intercepts, allowing for non 0 
asymptotic levels of the processes.  
"auto" freely estimates all parameters.}

\item{DIFFUSION}{lower triangular n.latent*n.latent cholesky matrix of diffusion process 
variance and covariance (latent error / dynamic innovation).
"auto" freely estimates all parameters.}

\item{TRAITVAR}{Either NULL, if no trait / individual heterogeneity effect, 
or lower triangular n.latent*n.latent cholesky matrix of trait variance / covariance.
"auto" freely estimates all parameters.}

\item{MANIFESTTRAITVAR}{either NULL (default) if no trait variance / individual heterogeneity in the level of
the manifest indicators, otherwise a lower triangular n.manifest * n.manifest variance / covariance matrix. 
Set to "auto" to include and free all parameters - but identification problems will arise if \code{TRAITVAR} is 
also set.}

\item{n.TDpred}{Number of time dependent predictors in the dataset.
Each time dependent predictor must have Tpoints-1 columns 
(A value of a predictor at the final time point would not have any time to show an effect), 
which are included in the data matrix after manifest variables,
with the Tpoints-1 observations of the first predictor followed by those of the second and so on.}

\item{TDpredNames}{n.TDpred length vector of time dependent predictor variable names, 
as they appear in the data structure, without the _Tx time point suffix.  
Default names are TD1, TD2, etc.}

\item{TDPREDMEANS}{(n.TDpred * (Tpoints - 1)) rows * 1 column matrix of time dependent predictor means.
If 'auto', the means are freely estimated.  Otherwise, 
the means for the Tpoints-1 observations of your first time dependent predictor 
are followed by those of TDpred 2, and so on.}

\item{TDPREDEFFECT}{n.latent*n.TDpred matrix of effects from time dependent predictors to latent processes.
Effects from 1:n.TDpred columns TDpredictors go to 1:n.latent rows of latent processes.
"auto" freely estimates all parameters.}

\item{T0TDPREDCOV}{n.latent rows * ((Tpoints-1) rows * n.TDpred) columns covariance matrix 
between latents at T0 and time dependent predictors.
"auto" freely estimates all parameters.}

\item{TDPREDVAR}{lower triangular (n.TDpred * (Tpoints-1)) rows * (n.TDpred * (Tpoints-1)) columns variance / covariance
cholesky matrix for time dependent predictors.
"auto" (default) freely estimates all parameters.}

\item{TRAITTDPREDCOV}{n.latent rows * (n.TDpred*(Tpoints-1)) columns covariance matrix of 
latent traits and time dependent predictors.  
The Tpoints-1 columns of the first preditor are followed by those of the second and so on.
Covariances with the trait variance of latent process 1 are specified in row 1, process 2 in row 2, etc.
"auto" (default) freely estimates covariance between time dependent predictors and traits, 
(if both exist, otherwise this matrix is set to NULL, and ignored in any case).}

\item{TDTIPREDCOV}{(n.TDpred * (Tpoints-1)) rows * n.TIpred columns covariance
matrix between time dependent and time independent predictors.
"auto" (default) freely estimates all parameters.}

\item{n.TIpred}{Number of time independent predictors. 
Each TIpredictor is inserted at the right of the data matrix, after the time intervals.}

\item{TIpredNames}{n.TIpred length vector of time independent predictor variable names,
as they appear in the data structure.  Default names are TI1, TI2, etc.}

\item{TIPREDMEANS}{n.TIpred * 1 matrix of time independent predictor means.
If 'auto', the means are freely estimated.}

\item{TIPREDEFFECT}{n.latent*n.TIpred effect matrix of time independent predictors on latent processes.
"auto" freely estimates all parameters and generates starting values.}

\item{T0TIPREDEFFECT}{n.latent*n.TIpred effect matrix of time independent 
predictors on latents at T0. "auto" freely estimates all parameters, though note that under the default 
setting of \code{stationary} for \code{ctFit}, this matrix is ignored as the effects are determined based on
the overall process parameters.}

\item{TIPREDVAR}{symmetric n.TIpred * n.TIpred variance / covariance
matrix for all time independent predictors.
"auto" (default) freely estimates all parameters.}

\item{startValues}{a named vector, where the names of each value must match a parameter in the specified model,
and the value sets the starting value for that parameter during optimization.
If not set, random starting values representing relatively stable processes with small effects and 
covariances are generated by ctFit.  
Better starting values may improve model fit speed and the chance of an appropriate model fit.}
}
\description{
This function is used to specify a continuous time structural equation model, 
which can then be fit to data with function \code{\link{ctFit}}.
}
\examples{

 ### impulse and level change time dependent predictor example from Driver, Oud, Voelkle (2015)
 data('ctExample2')
 tdpredmodel <- ctModel(n.manifest = 2, n.latent = 3, n.TDpred = 1, 
 Tpoints = 8, manifestNames = c('LeisureTime', 'Happiness'), 
 TDpredNames = 'MoneyInt', 
 latentNames = c('LeisureTime', 'Happiness', 'MoneyIntLatent'),
 T0TDPREDCOV = matrix(0, nrow = 3, ncol = 7),
 TRAITTDPREDCOV = matrix(0, nrow = 3, ncol = 7), 
 LAMBDA = matrix(c(1,0, 0,1, 0,0), ncol = 3), TRAITVAR = "auto")

 tdpredmodel$TRAITVAR[3, ] <- 0
 tdpredmodel$TRAITVAR[, 3] <- 0
 tdpredmodel$DIFFUSION[, 3] <- 0
 tdpredmodel$DIFFUSION[3, ] <- 0
 tdpredmodel$T0VAR[3, ] <- 0
 tdpredmodel$T0VAR[, 3] <- 0
 tdpredmodel$CINT[3] <- 0
 tdpredmodel$T0MEANS[3] <- 0
 tdpredmodel$TDPREDEFFECT[3, ] <- 1
 tdpredmodel$DRIFT[3, ] <- 0

 \dontrun{
 tdpredfit <- ctFit(datawide = ctExample2, ctmodelobj = tdpredmodel)

 summary(tdpredfit)
 }

}

