% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctDiscretePars.R
\name{ctStanContinuousPars}
\alias{ctStanContinuousPars}
\title{ctStanContinuousPars}
\usage{
ctStanContinuousPars(ctstanfitobj, subjects = "all", iter = "all",
  calcfunc = mean, ...)
}
\arguments{
\item{ctstanfitobj}{fit object from \code{\link{ctStanFit}}}

\item{subjects}{Either 'all', or integers denoting which subjects to perform the calculation over. 
When multiple subjects are specified, the returned matrices will be a mean over subjects.}

\item{iter}{Either character string 'all' which will then use all post-warmup iterations, 
or an integer specifying which iteration/s to use.}

\item{calcfunc}{Function to apply over samples, must return a single value. 
By default the mean over all samples is returned, but one might also be interested in
the \code{\link[stats]{sd}} or \code{\link[stats]{quantile}} functions.}

\item{...}{additional parameters to pass to calcfunc. For instance, with calcfunc = quantile, 
the probs argument is needed to ensure only a single value is returned.}
}
\description{
Returns the continuous time parameter matrices for specified subjects of a ctStanFit fit object
}
\examples{
#posterior mean over all subjects
ctStanContinuousPars(ctstantestfit)

#posterior 95\% quantiles for subject 2
ctStanContinuousPars(ctstantestfit, subjects=2, calcfunc=quantile, probs = .95)
}

