% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ctsemFit.R
\name{plot.ctsemFit}
\alias{plot.ctsemFit}
\title{Plotting function for object class ctsemFit}
\usage{
\method{plot}{ctsemFit}(x, resolution = 50, wait = TRUE,
  max.time = "auto", mean = TRUE, withinVariance = TRUE, AR = TRUE,
  CR = TRUE, standardiseCR = TRUE, randomImpulse = FALSE,
  experimentalImpulse = FALSE, xlab = "Time", meansylim = "auto",
  ARylim = "auto", CRylim = "auto", ylab = "Value", ...)
}
\arguments{
\item{x}{ctsemFit object as generated by \code{\link{ctFit}}.}

\item{resolution}{Numeric. Plot points between each unit of time. Default of 'auto' adapts to max.time and results in 500 in total.}

\item{wait}{If true, user is prompted to continue before plotting next graph.  If false, graphs are plotted one after another without waiting.}

\item{max.time}{Time scale on which to plot parameters.  If auto, parameters are plotted for full range of observed variables.}

\item{mean}{if TRUE, plot of means from 0 to max.time included in output.}

\item{withinVariance}{if TRUE, plot within subject variance / covariance.}

\item{AR}{if TRUE, plot of autoregressive values from 0 to max.time included in output.}

\item{CR}{if TRUE, plot of cross regressive values from 0 to max.time included in output.}

\item{standardiseCR}{if TRUE (default), cross regression values are standardised based on estimated within subject variance.}

\item{randomImpulse}{if TRUE (default), plots expected change in processes given a random fluctuation of +1 for each process -- 
plot is then a mixture of DIFFUSION and DRIFT characteristics.}

\item{experimentalImpulse}{if TRUE (default), plots expected change in processes given an exogenous input of +1 for each process -- 
alternate characterisation of autoregressive and cross regressive plots.}

\item{xlab}{X axis label.}

\item{meansylim}{Vector of min and max limits for mean trajectory plot. 'auto' calculates automatically.}

\item{ARylim}{Vector of min and max limits for autoregression plot. 'auto' is c(0,1), and expands if necessary.}

\item{CRylim}{Vector of min and max limits for cross regression plot. 'auto' is c(-1,1), and expands if necessary.}

\item{ylab}{Y axis label.}

\item{...}{Other options passed to \code{plot()}.}
}
\value{
Nothing. Side-effect: plots graphs.
}
\description{
Ouputs mean trajectories, autoregression, and crossregression plots. 
For more customization possibilities, see \code{\link{ctPlot}}.
}
\examples{
## Examples set to 'dontrun' because they take longer than 5s.

### example from Driver, Oud, Voelkle (2015), 
### simulated happiness and leisure time with unobserved heterogeneity.
\dontrun{
data(ctExample1)
traitmodel <- ctModel(n.manifest=2, n.latent=2, Tpoints=6, LAMBDA=diag(2), 
  manifestNames=c('LeisureTime', 'Happiness'), 
  latentNames=c('LeisureTime', 'Happiness'), TRAITVAR="auto")
traitfit <- ctFit(datawide=ctExample1, ctmodelobj=traitmodel)
plot(traitfit, wait=FALSE)
}
}

