% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctsemUtils.R
\name{ctPoly}
\alias{ctPoly}
\title{Plots uncertainty bands with shading}
\usage{
ctPoly(x, y, ylow, yhigh, steps = 20, ...)
}
\arguments{
\item{x}{x values}

\item{y}{y values}

\item{ylow}{lower limits of y}

\item{yhigh}{upper limits of y}

\item{steps}{number of polygons to overlay - higher integers lead to 
smoother changes in transparency between y and yhigh / ylow.}

\item{...}{arguments to pass to polygon()}
}
\value{
Nothing. Adds a polygon to existing plot.
}
\description{
Plots uncertainty bands with shading
}
\examples{
plot(0:100,sqrt(0:100),type='l')
ctPoly(x=0:100, y=sqrt(0:100), 
yhigh=sqrt(0:100) - runif(101), 
ylow=sqrt(0:100) + runif(101),
col=adjustcolor('red',alpha.f=.1),border=NA)
}
