% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctDataHelp.R
\name{datastructure}
\alias{datastructure}
\title{datastructure}
\format{2 by 15 matrix containing containing ctsem wide format data. 
3 measurement occasions of manifest variables Y1 and Y2, 
2 measurement occasions of time dependent predictor TD1, 
2 measurement intervals dTx, and 2 time independent predictors 
TI1 and TI2, for 2 individuals.}
\description{
Simulated example dataset for the ctsem package
}
\examples{
\dontrun{
Tpoints=30
testm<-ctModel(Tpoints=Tpoints,n.latent=1,n.TDpred=1,n.TIpred=2,n.manifest=3,    
  LAMBDA=matrix(1,ncol=1,nrow=3),
  DRIFT=diag(-.3,1),
  DIFFUSION=diag(.1,1),
  CINT=diag(2,1),
  MANIFESTVAR=diag(1,3),
  TDPREDEFFECT=diag(.2,1),
  TIPREDEFFECT=matrix(.8,nrow=1,ncol=2),
  TDPREDVAR=diag(1,1*(Tpoints)),
  TIPREDVAR=diag(1,2)
)
longexample<-round(ctGenerate(testm,n.subjects=2,logdtsd = 1,burnin=3,wide=FALSE)[c(1:3,32:34),],2)
longexample[2,c(2,7)]<-NA
longexample[4,c(3)]<-NA
datastructure <- ctLongToWide(datalong = longexample,id='id',time='time',
  manifestNames = testm$manifestNames,TDpredNames = testm$TDpredNames,
  TIpredNames=testm$TIpredNames)
datastructure<-ctIntervalise(datawide = datastructure,
  Tpoints = 3,n.manifest = testm$n.manifest,n.TDpred = testm$n.TDpred,
  n.TIpred=testm$n.TIpred)
save(datastructure,file='.\\\\data\\\\datastructure.rda')
}
}
