% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctWideToLong.R
\name{ctWideToLong}
\alias{ctWideToLong}
\title{ctWideToLong
Convert ctsem wide to long format}
\usage{
ctWideToLong(
  datawide,
  Tpoints,
  n.manifest,
  n.TDpred = 0,
  n.TIpred = 0,
  manifestNames = "auto",
  TDpredNames = "auto",
  TIpredNames = "auto"
)
}
\arguments{
\item{datawide}{ctsem wide format data}

\item{Tpoints}{number of measurement occasions in data}

\item{n.manifest}{number of manifest variables}

\item{n.TDpred}{number of time dependent predictors}

\item{n.TIpred}{number of time independent predictors}

\item{manifestNames}{Character vector of manifest variable names.}

\item{TDpredNames}{Character vector of time dependent predictor names.}

\item{TIpredNames}{Character vector of time independent predictor names.}
}
\description{
ctWideToLong
Convert ctsem wide to long format
}
\details{
Names must account for *all* the columns in the data - i.e. do not leave certain variables out
just because you do not need them.
}
\examples{
#create wide data
wideexample <- ctLongToWide(datalong = ctstantestdat, id = "id", 
time = "time", manifestNames = c("Y1", "Y2"), 
TDpredNames = "TD1", TIpredNames = c("TI1", "TI2","TI3"))

wide <- ctIntervalise(datawide = wideexample, Tpoints = 10, n.manifest = 2, 
n.TDpred = 1, n.TIpred = 3, manifestNames = c("Y1", "Y2"), 
TDpredNames = "TD1", TIpredNames = c("TI1", "TI2","TI3") )

 #Then convert to long format
 longexample <- ctWideToLong(datawide = wideexample, Tpoints=10, 
 n.manifest=2, manifestNames = c("Y1", "Y2"),
 n.TDpred=1, TDpredNames = "TD1", 
 n.TIpred=3, TIpredNames = c("TI1", "TI2","TI3"))

 #Then convert the time intervals to absolute time
 long <- ctDeintervalise(datalong = longexample, id='id', dT='dT')
 head(long,22)


}
