% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-hex.R
\name{read_hex}
\alias{read_hex}
\title{Read bytes as hexadecimal strings}
\usage{
read_hex(con, n = 1, size = 1, endian = NULL)
}
\arguments{
\item{con}{Connection object or raw vector. Connection objects can be 
created with \code{file()}, \code{url()}, 
\code{rawConnection()} or any of the other many connection creation
functions.}

\item{n}{Number of hexadecimal strings to read. Default: 1}

\item{size}{size in bytes of each string. Default: 1}

\item{endian}{Ordering of bytes within the file when reading multi-byte values.
Possible values: 'big' or 'little'.  
Default: NULL indicates that
endian option should be retrieved from the connection object if possible
(where the user has used \code{\link{set_endian}()}) or otherwise 
will be set to \code{"little"}}
}
\value{
vector of hexadecimal character strings
}
\description{
Read bytes as hexadecimal strings
}
\examples{
con <- rawConnection(as.raw(1:4))
read_hex(con, n = 4, size = 1)
close(con)

con <- rawConnection(as.raw(1:4))
read_hex(con, n = 1, size = 4)
close(con)

con <- rawConnection(as.raw(1:4))
read_hex(con, n = 2, size = 2, endian = "big")
close(con)
}
\seealso{
Other data input functions: 
\code{\link{read_f64}()},
\code{\link{read_raw}()},
\code{\link{read_str}()},
\code{\link{read_uint8}()},
\code{\link{scan_dbl}()}
}
\concept{data input functions}
