% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbc.R
\name{cbc}
\alias{cbc}
\title{Restricted cubic splines with cure}
\usage{
cbc(x, df = NULL, knots = NULL, ortho = FALSE, R.inv = NULL, intercept = FALSE)
}
\arguments{
\item{x}{Values to evaluate the basis functions in.}

\item{df}{Degrees of freedom. One can supply \code{df} rather than knots; \code{cbc} then chooses \code{df + 1} knots
at suitably chosen quantiles of \code{x} (which will ignore missing values) and adds an additional knot at the 95th
quantile of \code{x}.}

\item{knots}{Chosen knots for the spline.}

\item{ortho}{Logical. If \code{TRUE} orthogonalization of the basis matrix is carried out.}

\item{R.inv}{Matrix or vector containing the values of the R matrix from the QR decomposition of the basis matrix.
This is used for making new predictions based on the initial orthogonalization.
Therefore the default is \code{NULL}.}

\item{intercept}{Logical. If \code{FALSE}, the intercept of the restricted cubic spline is removed.}
}
\value{
A matrix with containing the basis functions evaluated in \code{x}.
}
\description{
Function for computing the basis matrix for restricted cubic splines which are constant beyond the last knot
}
\references{
Andersson T.M.-L., et al. (2011) Estimating and modelling cure in population-based cancer
studies within the framework of flexible parametric survival models.
\emph{BMC Medical Research Methodology}, 11:96.
}
