% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{climate_flat}
\alias{climate_flat}
\alias{stations}
\alias{climate}
\title{Australia climate data - 5 stations}
\format{
A tibble object with 155 rows and 10 columns
\describe{
\item{id}{station id}
\item{lat}{latitude of the station}
\item{long}{longitude of the station}
\item{elev}{elevation of the station}
\item{name}{station name}
\item{wmo_id}{the world meteorological organisation (WMO) station number}
\item{date}{the date that prcp, tmax, and tmin recorded}
\item{prcp}{precipitation}
\item{tmax}{maximum temperature}
\item{tmin}{minimum temperature}
}

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 5 rows and 6 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1830 rows and 5 columns.
}
\usage{
climate_flat

stations

climate
}
\description{
Daily measure on precipitation (prcp) maximum temperature (tmax), and
minimum temperature (tmin) in 2020 for 5 stations.
}
\examples{
climate_flat \%>\% as_cubble(key = id, index = date, coords = c(long, lat))
}
\seealso{
climate_aus climate_subset
}
\keyword{datasets}
