% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map-glyph.R
\name{geom_glyph}
\alias{geom_glyph}
\alias{geom_glyph_line}
\alias{geom_glyph_box}
\title{Create glyph map with ggplot2}
\usage{
geom_glyph(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  x_major = NULL,
  x_minor = NULL,
  y_major = NULL,
  y_minor = NULL,
  x_scale = identity,
  y_scale = identity,
  polar = FALSE,
  width = ggplot2::rel(2.1),
  height = ggplot2::rel(1.8),
  global_rescale = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_glyph_line(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  x_major = NULL,
  x_minor = NULL,
  y_major = NULL,
  y_minor = NULL,
  polar = FALSE,
  width = ggplot2::rel(2.1),
  height = ggplot2::rel(2.1),
  show.legend = NA,
  inherit.aes = TRUE
)

geom_glyph_box(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  x_major = NULL,
  x_minor = NULL,
  y_major = NULL,
  y_minor = NULL,
  polar = FALSE,
  width = ggplot2::rel(2.1),
  height = ggplot2::rel(2.1),
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{x_major, x_minor, y_major, y_minor}{The name of the variable (as a
string) for the major and minor x and y axes. Together, each unique
combination of \code{x_major} and \code{y_major} specifies a grid cell.}

\item{y_scale, x_scale}{The scaling function to be applied to each set of
minor values within a grid cell. Defaults to \code{\link{identity}} so
that no scaling is performed.}

\item{polar}{A logical of length 1, specifying whether the glyphs should
be drawn in polar coordinates.  Defaults to \code{FALSE}.}

\item{height, width}{The height and width of each glyph. Defaults to 95\% of
the \code{\link[ggplot2]{resolution}} of the data. Specify the width
absolutely by supplying a numeric vector of length 1, or relative to the
resolution of the data by using \code{\link[ggplot2]{rel}}.}

\item{global_rescale}{Whether rescale is performed globally or on each
individual glyph.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
a ggplot object
}
\description{
Create glyph map with ggplot2
}
\examples{
print_p <- GGally::print_if_interactive

library(ggplot2)
# basic glyph map with reference line and box---------------
p <- ggplot(data = GGally::nasa,
       aes(x_major = long, x_minor = day,
           y_major = lat, y_minor = surftemp)) +
  geom_glyph_box() +
  geom_glyph_line() +
  geom_glyph() +
  theme_bw()
print_p(p)

# rescale on each individual glyph ---------------
p <- ggplot(data = GGally::nasa,
       aes(x_major = long, x_minor = day,
           y_major = lat, y_minor = surftemp)) +
  geom_glyph(global_rescale = FALSE)
print_p(p)

# adjust width and height with relative & absolute value ---------------
p <- ggplot() +
  geom_glyph(data = GGally::nasa,
             aes(x_major = long, x_minor = day,
                 y_major = lat, y_minor = surftemp),
                 width = rel(0.8), height = 1) +
   theme_bw()
print_p(p)

# apply a re-scaling on Y and use polar coordinate
p <-
  GGally::nasa \%>\%
  ggplot(aes(x_major = long, x_minor = day,
             y_major = lat, y_minor = ozone)) +
    geom_glyph_box(fill=NA) +
    geom_glyph_line() +
    geom_glyph(y_scale = GGally::range01, polar = TRUE)
print_p(p)
}
