% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-cubble.R
\name{as_cubble}
\alias{as_cubble}
\alias{as_cubble.data.frame}
\alias{as_cubble.tbl_df}
\alias{as_cubble.sf}
\alias{as_cubble.ncdf4}
\alias{as_cubble.stars}
\alias{as_cubble.sftime}
\title{Coerce foreign objects into a cubble object}
\usage{
as_cubble(data, key, index, coords, ...)

\method{as_cubble}{data.frame}(data, key, index, coords, ...)

\method{as_cubble}{tbl_df}(data, key, index, coords, crs, ...)

\method{as_cubble}{sf}(data, key, index, ...)

\method{as_cubble}{ncdf4}(
  data,
  key,
  index,
  coords,
  vars,
  lat_range = NULL,
  long_range = NULL,
  ...
)

\method{as_cubble}{stars}(data, key, index, coords, ...)

\method{as_cubble}{sftime}(data, key, index, coords, ...)
}
\arguments{
\item{data}{an object to be converted into an cubble object. Currently
support objects of classes \code{tibble}, \code{ncdf4}, \code{stars}, and \code{sftime}.}

\item{key}{a character (symbol), the spatial identifier,
see \code{\link[=make_cubble]{make_cubble()}}}

\item{index}{a character (symbol), the temporal identifier,
see \code{\link[=make_cubble]{make_cubble()}}.}

\item{coords}{a vector of character (symbol) of length 2,
see \code{\link[=make_cubble]{make_cubble()}}.}

\item{...}{other arguments.}

\item{crs}{used in \code{as_cubble.tbl_df()} to set the crs.
the data to read in \code{as_cubble.netcdf()}.}

\item{vars}{a vector of variables to read in (with quote),
used in \code{as_cubble.netcdf()}
to select the variable to read in.}

\item{lat_range, long_range}{in the syntax of \code{seq(FROM, TO, BY)}
to downsample}
}
\value{
a cubble object
}
\description{
Coerce foreign objects into a cubble object
}
\examples{
climate_flat |> as_cubble(key = id, index = date, coords = c(long, lat))

# only need `coords` if create from a tsibble
dt <- climate_flat |>  tsibble::as_tsibble(key = id, index = date)
dt |>  as_cubble(coords = c(long, lat))

# netcdf
path <- system.file("ncdf/era5-pressure.nc", package = "cubble")
raw <- ncdf4::nc_open(path)
dt <- as_cubble(raw)
# subset degree
dt <- as_cubble(raw,vars = c("q", "z"),
                long_range = seq(113, 153, 3),
                lat_range = seq(-53, -12, 3))

\dontrun{
# stars - take a few seconds to run
tif <- system.file("tif/L7_ETMs.tif", package = "stars")
x <-  stars::read_stars(tif)
x |> as_cubble(index = band)
}

# don't have to supply coords if create from a sftime
dt <- climate_flat |>
  sf::st_as_sf(coords = c("long", "lat"), crs = sf::st_crs("OGC:CRS84")) |>
  sftime::st_as_sftime()
dt |> as_cubble(key = id, index = date)
}
