
###################################################

# (getMoveCube) (getSliceCube) (getRotCube) 
# (getPOMoveCube)

###################################################

# get move cubes for cubieCube representation
# code is isolated: no calls to other functions 
# all functions are internal

getMoveCube <- function(move) 
{
  out <- switch(EXPR = move,
         "U1" = ,
         "U" = list(cp = c(4, 1, 2, 3, 5, 6, 7, 8), 
                    ep = c(1, 2, 3, 4, 8, 5, 6, 7, 9, 10, 11, 12), 
                    co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                    eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "R1" = ,
         "R" = list(cp = c(5, 2, 3, 1, 8, 6, 7, 4), 
                    ep = c(9, 2, 3, 5, 1, 6, 7, 8, 4, 10, 11, 12), 
                    co = c(2, 0, 0, 1, 1, 0, 0, 2), 
                    eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "F1" = ,
         "F" = list(cp = c(2, 6, 3, 4, 1, 5, 7, 8), 
                    ep = c(6, 10, 3, 4, 5, 2, 7, 8, 9, 1, 11, 12), 
                    co = c(1, 2, 0, 0, 2, 1, 0, 0),
                    eo = c(1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0)),
         "D1" = ,
         "D" = list(cp = c(1, 2, 3, 4, 6, 7, 8, 5), 
                    ep = c(1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 9), 
                    co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                    eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "L1" = ,
         "L" = list(cp = c(1, 3, 7, 4, 5, 2, 6, 8), 
                    ep = c(1, 7, 11, 4, 5, 6, 3, 8, 9, 10, 2, 12), 
                    co = c(0, 1, 2, 0, 0, 2, 1, 0), 
                    eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "B1" = ,
         "B" = list(cp = c(1, 2, 4, 8, 5, 6, 3, 7), 
                    ep = c(1, 2, 8, 12, 5, 6, 7, 4, 9, 10, 11, 3), 
                    co = c(0, 0, 1, 2, 0, 0, 2, 1), 
                    eo = c(0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1)),
         "U'" = ,
         "U3" = list(cp = c(2, 3, 4, 1, 5, 6, 7, 8), 
                     ep = c(1, 2, 3, 4, 6, 7, 8, 5, 9, 10, 11, 12), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "R'" = ,
         "R3" = list(cp = c(4, 2, 3, 8, 1, 6, 7, 5), 
                     ep = c(5, 2, 3, 9, 4, 6, 7, 8, 1, 10, 11, 12), 
                     co = c(2, 0, 0, 1, 1, 0, 0, 2), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "F'" = ,
         "F3" = list(cp = c(5, 1, 3, 4, 6, 2, 7, 8), 
                     ep = c(10, 6, 3, 4, 5, 1, 7, 8, 9, 2, 11, 12), 
                     co = c(1, 2, 0, 0, 2, 1, 0, 0),
                     eo = c(1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0)),
         "D'" = ,
         "D3" = list(cp = c(1, 2, 3, 4, 8, 5, 6, 7), 
                     ep = c(1, 2, 3, 4, 5, 6, 7, 8, 12, 9, 10, 11), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "L'" = ,
         "L3" = list(cp = c(1, 6, 2, 4, 5, 7, 3, 8), 
                     ep = c(1, 11, 7, 4, 5, 6, 2, 8, 9, 10, 3, 12), 
                     co = c(0, 1, 2, 0, 0, 2, 1, 0), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "B'" = ,
         "B3" = list(cp = c(1, 2, 7, 3, 5, 6, 8, 4), 
                     ep = c(1, 2, 12, 8, 5, 6, 7, 3, 9, 10, 11, 4), 
                     co = c(0, 0, 1, 2, 0, 0, 2, 1), 
                     eo = c(0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1)),
         "U2'" = ,
         "U2" = list(cp = c(3, 4, 1, 2, 5, 6, 7, 8), 
                     ep = c(1, 2, 3, 4, 7, 8, 5, 6, 9, 10, 11, 12), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "R2'" = ,
         "R2" = list(cp = c(8, 2, 3, 5, 4, 6, 7, 1), 
                     ep = c(4, 2, 3, 1, 9, 6, 7, 8, 5, 10, 11, 12), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "F2'" = ,
         "F2" = list(cp = c(6, 5, 3, 4, 2, 1, 7, 8), 
                     ep = c(2, 1, 3, 4, 5, 10, 7, 8, 9, 6, 11, 12), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0),
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "D2'" = ,
         "D2" = list(cp = c(1, 2, 3, 4, 7, 8, 5, 6), 
                     ep = c(1, 2, 3, 4, 5, 6, 7, 8, 11, 12, 9, 10), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "L2'" = ,
         "L2" = list(cp = c(1, 7, 6, 4, 5, 3, 2, 8), 
                     ep = c(1, 3, 2, 4, 5, 6, 11, 8, 9, 10, 7, 12), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "B2'" = ,
         "B2" = list(cp = c(1, 2, 8, 7, 5, 6, 4, 3), 
                     ep = c(1, 2, 4, 3, 5, 6, 7, 12, 9, 10, 11, 8),
                     co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         stop("illegal move"))
  
  names(out$cp) <- names(out$co) <- c("URF", "UFL", "ULB", "UBR", "DFR", "DLF", "DBL", "DRB")
  names(out$ep) <- names(out$eo) <- c("FR", "FL", "BL", "BR", "UR", "UF", "UL", "UB", "DR", "DF", "DL", "DB")
  class(out) <- c("cubieCube", "cube")
  out
}

# E = D'Uy' / M = L'Rx' / S = B'Fz'  
# does not include the rotation
getSliceCube <- function(move) 
{
  out <- switch(EXPR = move,
         "D'U" = ,
         "E1" = ,
         "E" = list(cp = c(4, 1, 2, 3, 8, 5, 6, 7), 
                    ep = c(1, 2, 3, 4, 8, 5, 6, 7, 12, 9, 10, 11), 
                    co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                    eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "L'R" = ,
         "M1" = ,
         "M" = list(cp = c(5, 6, 2, 1, 8, 7, 3, 4), 
                    ep = c(9, 11, 7, 5, 1, 6, 2, 8, 4, 10, 3, 12), 
                    co = c(2, 1, 2, 1, 1, 2, 1, 2), 
                    eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "B'F" = ,
         "S1" = ,
         "S" = list(cp = c(2, 6, 7, 3, 1, 5, 8, 4), 
                    ep = c(6, 10, 12, 8, 5, 2, 7, 3, 9, 1, 11, 4), 
                    co = c(1, 2, 1, 2, 2, 1, 2, 1),
                    eo = c(1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1)),
         "DU'" = ,
         "E'" = ,
         "E3" = list(cp = c(2, 3, 4, 1, 6, 7, 8, 5), 
                     ep = c(1, 2, 3, 4, 6, 7, 8, 5, 10, 11, 12, 9), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "LR'" = ,
         "M'" = ,
         "M3" = list(cp = c(4, 3, 7, 8, 1, 2, 6, 5), 
                     ep = c(5, 7, 11, 9, 4, 6, 3, 8, 1, 10, 2, 12), 
                     co = c(2, 1, 2, 1, 1, 2, 1, 2), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "BF'" = ,
         "S'" = ,
         "S3" = list(cp = c(5, 1, 4, 8, 6, 2, 3, 7), 
                     ep = c(10, 6, 8, 12, 5, 1, 7, 4, 9, 2, 11, 3), 
                     co = c(1, 2, 1, 2, 2, 1, 2, 1),
                     eo = c(1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1)),
         "D2U2" = ,
         "E2'" = ,
         "E2" = list(cp = c(3, 4, 1, 2, 7, 8, 5, 6), 
                     ep = c(1, 2, 3, 4, 7, 8, 5, 6, 11, 12, 9, 10), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "L2R2" = ,
         "M2'" = ,
         "M2" = list(cp = c(8, 7, 6, 5, 4, 3, 2, 1), 
                     ep = c(4, 3, 2, 1, 9, 6, 11, 8, 5, 10, 7, 12), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         "B2F2" = ,
         "S2'" = ,
         "S2" = list(cp = c(6, 5, 8, 7, 2, 1, 4, 3), 
                     ep = c(2, 1, 4, 3, 5, 10, 7, 12, 9, 6, 11, 8), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0),
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
         stop("illegal move"))
  
  names(out$cp) <- names(out$co) <- c("URF", "UFL", "ULB", "UBR", "DFR", "DLF", "DBL", "DRB")
  names(out$ep) <- names(out$eo) <- c("FR", "FL", "BL", "BR", "UR", "UF", "UL", "UB", "DR", "DF", "DL", "DB")
  class(out) <- c("cubieCube", "cube")
  out
}

# get one of 24 rotations
getRotCube <- function(move) 
{
  if(move < 1 || move > 24)
    stop("rotation must be an integer between 1 and 24")
  out <- switch(EXPR = move,
                #1
                list(cp = c(1, 2, 3, 4, 5, 6, 7, 8), 
                    ep = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12), 
                    co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                    eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
                #2
                list(cp = c(4, 1, 2, 3, 8, 5, 6, 7), 
                    ep = c(4, 1, 2, 3, 8, 5, 6, 7, 12, 9, 10, 11), 
                    co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                    eo = c(1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0)),
                #3
                list(cp = c(3, 4, 1, 2, 7, 8, 5, 6), 
                    ep = c(3, 4, 1, 2, 7, 8, 5, 6, 11, 12, 9, 10), 
                    co = c(0, 0, 0, 0, 0, 0, 0, 0),
                    eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
                #4
                list(cp = c(2, 3, 4, 1, 6, 7, 8, 5), 
                    ep = c(2, 3, 4, 1, 6, 7, 8, 5, 10, 11, 12, 9), 
                    co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                    eo = c(1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0)),
                #5
                list(cp = c(6, 5, 8, 7, 2, 1, 4, 3), 
                     ep = c(2, 1, 4, 3, 11, 10, 9, 12, 7, 6, 5, 8), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
                #6
                list(cp = c(7, 6, 5, 8, 3, 2, 1, 4), 
                     ep = c(3, 2, 1, 4, 12, 11, 10, 9, 8, 7, 6, 5), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                     eo = c(1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0)),
                #7
                list(cp = c(8, 7, 6, 5, 4, 3, 2, 1), 
                     ep = c(4, 3, 2, 1, 9, 12, 11, 10, 5, 8, 7, 6), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0),
                     eo = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
                #8
                list(cp = c(5, 8, 7, 6, 1, 4, 3, 2), 
                     ep = c(1, 4, 3, 2, 10, 9, 12, 11, 6, 5, 8, 7), 
                     co = c(0, 0, 0, 0, 0, 0, 0, 0), 
                     eo = c(1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0)),
                #9
                list(cp = c(1, 5, 6, 2, 4, 8, 7, 3), 
                     ep = c(5, 9, 11, 7, 6, 1, 10, 2, 8, 4, 12, 3), 
                     co = c(1, 2, 1, 2, 2, 1, 2, 1), 
                     eo = c(1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0)),
                #10
                list(cp = c(2, 1, 5, 6, 3, 4, 8, 7), 
                     ep = c(7, 5, 9, 11, 2, 6, 1, 10, 3, 8, 4, 12), 
                     co = c(2, 1, 2, 1, 1, 2, 1, 2), 
                     eo = c(0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1)),
                #11
                list(cp = c(6, 2, 1, 5, 7, 3, 4, 8), 
                     ep = c(11, 7, 5, 9, 10, 2, 6, 1, 12, 3, 8, 4), 
                     co = c(1, 2, 1, 2, 2, 1, 2, 1),
                     eo = c(1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0)),
                #12
                list(cp = c(5, 6, 2, 1, 8, 7, 3, 4), 
                     ep = c(9, 11, 7, 5, 1, 10, 2, 6, 4, 12, 3, 8), 
                     co = c(2, 1, 2, 1, 1, 2, 1, 2), 
                     eo = c(0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1)),
                #13
                list(cp = c(8, 4, 3, 7, 5, 1, 2, 6), 
                     ep = c(9, 5, 7, 11, 12, 4, 8, 3, 10, 1, 6, 2), 
                     co = c(1, 2, 1, 2, 2, 1, 2, 1), 
                     eo = c(1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0)),
                #14
                list(cp = c(7, 8, 4, 3, 6, 5, 1, 2), 
                     ep = c(11, 9, 5, 7, 3, 12, 4, 8, 2, 10, 1, 6), 
                     co = c(2, 1, 2, 1, 1, 2, 1, 2), 
                     eo = c(0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1)),
                #15
                list(cp = c(3, 7, 8, 4, 2, 6, 5, 1), 
                     ep = c(7, 11, 9, 5, 8, 3, 12, 4, 6, 2, 10, 1), 
                     co = c(1, 2, 1, 2, 2, 1, 2, 1),
                     eo = c(1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0)),
                #16
                list(cp = c(4, 3, 7, 8, 1, 2, 6, 5), 
                     ep = c(5, 7, 11, 9, 4, 8, 3, 12, 1, 6, 2, 10), 
                     co = c(2, 1, 2, 1, 1, 2, 1, 2), 
                     eo = c(0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1)),
                #17
                list(cp = c(1, 4, 8, 5, 2, 3, 7, 6), 
                     ep = c(6, 8, 12, 10, 1, 5, 4, 9, 2, 7, 3, 11), 
                     co = c(2, 1, 2, 1, 1, 2, 1, 2), 
                     eo = c(0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1)),
                #18
                list(cp = c(5, 1, 4, 8, 6, 2, 3, 7), 
                     ep = c(10, 6, 8, 12, 9, 1, 5, 4, 11, 2, 7, 3), 
                     co = c(1, 2, 1, 2, 2, 1, 2, 1), 
                     eo = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)),
                #19
                list(cp = c(8, 5, 1, 4, 7, 6, 2, 3), 
                     ep = c(12, 10, 6, 8, 4, 9, 1, 5, 3, 11, 2, 7), 
                     co = c(2, 1, 2, 1, 1, 2, 1, 2),
                     eo = c(0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1)),
                #20
                list(cp = c(4, 8, 5, 1, 3, 7, 6, 2), 
                     ep = c(8, 12, 10, 6, 5, 4, 9, 1, 7, 3, 11, 2), 
                     co = c(1, 2, 1, 2, 2, 1, 2, 1), 
                     eo = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)),
                #21
                list(cp = c(3, 2, 6, 7, 4, 1, 5, 8), 
                     ep = c(8, 6, 10, 12, 3, 7, 2, 11, 4, 5, 1, 9), 
                     co = c(2, 1, 2, 1, 1, 2, 1, 2), 
                     eo = c(0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1)),
                #22
                list(cp = c(7, 3, 2, 6, 8, 4, 1, 5), 
                     ep = c(12, 8, 6, 10, 11, 3, 7, 2, 9, 4, 5, 1), 
                     co = c(1, 2, 1, 2, 2, 1, 2, 1), 
                     eo = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)),
                #23
                list(cp = c(6, 7, 3, 2, 5, 8, 4, 1), 
                     ep = c(10, 12, 8, 6, 2, 11, 3, 7, 1, 9, 4, 5), 
                     co = c(2, 1, 2, 1, 1, 2, 1, 2),
                     eo = c(0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1)),
                #24
                list(cp = c(2, 6, 7, 3, 1, 5, 8, 4), 
                     ep = c(6, 10, 12, 8, 7, 2, 11, 3, 5, 1, 9, 4), 
                     co = c(1, 2, 1, 2, 2, 1, 2, 1), 
                     eo = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)))
  
  names(out$cp) <- names(out$co) <- c("URF", "UFL", "ULB", "UBR", "DFR", "DLF", "DBL", "DRB")
  names(out$ep) <- names(out$eo) <- c("FR", "FL", "BL", "BR", "UR", "UF", "UL", "UB", "DR", "DF", "DL", "DB")
  class(out) <- c("cubieCube", "cube")
  out
}


getPOMoveCube <- function(move) 
{
  out <- switch(EXPR = move,
                "U1" = ,
                "U" = list(cp = c(4, 1, 2, 3, 5, 6, 7, 8), 
                           ep = c(1, 2, 3, 4, 8, 5, 6, 7, 9, 10, 11, 12), 
                           spor = c(1, 2, 3, 4, 5, 6)),
                "R1" = ,
                "R" = list(cp = c(5, 2, 3, 1, 8, 6, 7, 4), 
                           ep = c(9, 2, 3, 5, 1, 6, 7, 8, 4, 10, 11, 12), 
                           spor = c(1, 2, 3, 4, 5, 6)),
                "F1" = ,
                "F" = list(cp = c(2, 6, 3, 4, 1, 5, 7, 8), 
                           ep = c(6, 10, 3, 4, 5, 2, 7, 8, 9, 1, 11, 12), 
                           spor = c(1, 2, 3, 4, 5, 6)),
                "D1" = ,
                "D" = list(cp = c(1, 2, 3, 4, 6, 7, 8, 5), 
                           ep = c(1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 9), 
                           spor = c(1, 2, 3, 4, 5, 6)),
                "L1" = ,
                "L" = list(cp = c(1, 3, 7, 4, 5, 2, 6, 8), 
                           ep = c(1, 7, 11, 4, 5, 6, 3, 8, 9, 10, 2, 12), 
                           spor = c(1, 2, 3, 4, 5, 6)),
                "B1" = ,
                "B" = list(cp = c(1, 2, 4, 8, 5, 6, 3, 7), 
                           ep = c(1, 2, 8, 12, 5, 6, 7, 4, 9, 10, 11, 3), 
                           spor = c(1, 2, 3, 4, 5, 6)),
                "U'" = ,
                "U3" = list(cp = c(2, 3, 4, 1, 5, 6, 7, 8), 
                            ep = c(1, 2, 3, 4, 6, 7, 8, 5, 9, 10, 11, 12), 
                            spor = c(1, 2, 3, 4, 5, 6)),
                "R'" = ,
                "R3" = list(cp = c(4, 2, 3, 8, 1, 6, 7, 5), 
                            ep = c(5, 2, 3, 9, 4, 6, 7, 8, 1, 10, 11, 12),
                            spor = c(1, 2, 3, 4, 5, 6)),
                "F'" = ,
                "F3" = list(cp = c(5, 1, 3, 4, 6, 2, 7, 8), 
                            ep = c(10, 6, 3, 4, 5, 1, 7, 8, 9, 2, 11, 12), 
                            spor = c(1, 2, 3, 4, 5, 6)),
                "D'" = ,
                "D3" = list(cp = c(1, 2, 3, 4, 8, 5, 6, 7), 
                            ep = c(1, 2, 3, 4, 5, 6, 7, 8, 12, 9, 10, 11), 
                            spor = c(1, 2, 3, 4, 5, 6)),
                "L'" = ,
                "L3" = list(cp = c(1, 6, 2, 4, 5, 7, 3, 8), 
                            ep = c(1, 11, 7, 4, 5, 6, 2, 8, 9, 10, 3, 12), 
                            spor = c(1, 2, 3, 4, 5, 6)),
                "B'" = ,
                "B3" = list(cp = c(1, 2, 7, 3, 5, 6, 8, 4), 
                            ep = c(1, 2, 12, 8, 5, 6, 7, 3, 9, 10, 11, 4), 
                            spor = c(1, 2, 3, 4, 5, 6)),
                "U2'" = ,
                "U2" = list(cp = c(3, 4, 1, 2, 5, 6, 7, 8), 
                            ep = c(1, 2, 3, 4, 7, 8, 5, 6, 9, 10, 11, 12), 
                            spor = c(1, 2, 3, 4, 5, 6)),
                "R2'" = ,
                "R2" = list(cp = c(8, 2, 3, 5, 4, 6, 7, 1), 
                            ep = c(4, 2, 3, 1, 9, 6, 7, 8, 5, 10, 11, 12), 
                            spor = c(1, 2, 3, 4, 5, 6)),
                "F2'" = ,
                "F2" = list(cp = c(6, 5, 3, 4, 2, 1, 7, 8), 
                            ep = c(2, 1, 3, 4, 5, 10, 7, 8, 9, 6, 11, 12), 
                            spor = c(1, 2, 3, 4, 5, 6)),
                "D2'" = ,
                "D2" = list(cp = c(1, 2, 3, 4, 7, 8, 5, 6), 
                            ep = c(1, 2, 3, 4, 5, 6, 7, 8, 11, 12, 9, 10), 
                            spor = c(1, 2, 3, 4, 5, 6)),
                "L2'" = ,
                "L2" = list(cp = c(1, 7, 6, 4, 5, 3, 2, 8), 
                            ep = c(1, 3, 2, 4, 5, 6, 11, 8, 9, 10, 7, 12), 
                            spor = c(1, 2, 3, 4, 5, 6)),
                "B2'" = ,
                "B2" = list(cp = c(1, 2, 8, 7, 5, 6, 4, 3), 
                            ep = c(1, 2, 4, 3, 5, 6, 7, 12, 9, 10, 11, 8),
                            spor = c(1, 2, 3, 4, 5, 6)),
                "E1" = ,
                "E" = list(cp = c(1, 2, 3, 4, 5, 6, 7, 8), 
                           ep = c(2, 3, 4, 1, 5, 6, 7, 8, 9, 10, 11, 12), 
                           spor = c(1, 3, 5, 4, 6, 2)),
                "M1" = ,
                "M" = list(cp = c(1, 2, 3, 4, 5, 6, 7, 8), 
                           ep = c(1, 2, 3, 4, 5, 8, 7, 12, 9, 6, 11, 10), 
                           spor = c(6, 2, 1, 3, 5, 4)),
                "S1" = ,
                "S" = list(cp = c(1, 2, 3, 4, 5, 6, 7, 8), 
                           ep = c(1, 2, 3, 4, 9, 6, 5, 8, 11, 10, 7, 12), 
                           spor = c(2, 4, 3, 5, 1, 6)),
                "E'" = ,
                "E3" = list(cp = c(1, 2, 3, 4, 5, 6, 7, 8), 
                            ep = c(4, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12), 
                            spor = c(1, 6, 2, 4, 3, 5)),
                "M'" = ,
                "M3" = list(cp = c(1, 2, 3, 4, 5, 6, 7, 8), 
                            ep = c(1, 2, 3, 4, 5, 10, 7, 6, 9, 12, 11, 8), 
                            spor = c(3, 2, 4, 6, 5, 1)),
                "S'" = ,
                "S3" = list(cp = c(1, 2, 3, 4, 5, 6, 7, 8), 
                            ep = c(1, 2, 3, 4, 7, 6, 11, 8, 5, 10, 9, 12), 
                            spor = c(5, 1, 3, 2, 4, 6)),
                "E2'" = ,
                "E2" = list(cp = c(1, 2, 3, 4, 5, 6, 7, 8), 
                            ep = c(3, 4, 1, 2, 5, 6, 7, 8, 9, 10, 11, 12), 
                            spor = c(1, 5, 6, 4, 2, 3)),
                "M2'" = ,
                "M2" = list(cp = c(1, 2, 3, 4, 5, 6, 7, 8), 
                            ep = c(1, 2, 3, 4, 5, 12, 7, 10, 9, 8, 11, 6), 
                            spor = c(4, 2, 6, 1, 5, 3)),
                "S2'" = ,
                "S2" = list(cp = c(1, 2, 3, 4, 5, 6, 7, 8), 
                            ep = c(1, 2, 3, 4, 11, 6, 9, 8, 7, 10, 5, 12), 
                            spor = c(4, 5, 3, 1, 2, 6)),
                
                "y1" = ,
                "y" = list(cp = c(4, 1, 2, 3, 8, 5, 6, 7), 
                           ep = c(4, 1, 2, 3, 8, 5, 6, 7, 12, 9, 10, 11), 
                           spor = c(1, 6, 2, 4, 3, 5)),
                "x1" = ,
                "x" = list(cp = c(5, 6, 2, 1, 8, 7, 3, 4), 
                           ep = c(9, 11, 7, 5, 1, 10, 2, 6, 4, 12, 3, 8), 
                           spor = c(3, 2, 4, 6, 5, 1)),
                "z1" = ,
                "z" = list(cp = c(2, 6, 7, 3, 1, 5, 8, 4 ), 
                           ep = c(6, 10, 12, 8, 7, 2, 11, 3, 5, 1, 9, 4), 
                           spor = c(5, 1, 3, 2, 4, 6)),
                "y'" = ,
                "y3" = list(cp = c(2, 3, 4, 1, 6, 7, 8, 5), 
                            ep = c(2, 3, 4, 1, 6, 7, 8, 5, 10, 11, 12, 9), 
                            spor = c(1, 3, 5, 4, 6, 2)),
                "x'" = ,
                "x3" = list(cp = c(4, 3, 7, 8, 1, 2, 6, 5), 
                            ep = c(5, 7, 11, 9, 4, 8, 3, 12, 1, 6, 2, 10), 
                            spor = c(6, 2, 1, 3, 5, 4)),
                "z'" = ,
                "z3" = list(cp = c(5, 1, 4, 8, 6, 2, 3, 7), 
                            ep = c(10, 6, 8, 12, 9, 1, 5, 4, 11, 2, 7, 3), 
                            spor = c(2, 4, 3, 5, 1, 6)),
                "y2'" = ,
                "y2" = list(cp = c(3, 4, 1, 2, 7, 8, 5, 6), 
                            ep = c(3, 4, 1, 2, 7, 8, 5, 6, 11, 12, 9, 10), 
                            spor = c(1, 5, 6, 4, 2, 3)),
                "x2'" = ,
                "x2" = list(cp = c(8, 7, 6, 5, 4, 3, 2, 1), 
                            ep = c(4, 3, 2, 1, 9, 12, 11, 10, 5, 8, 7, 6), 
                            spor = c(4, 2, 6, 1, 5, 3)),
                "z2'" = ,
                "z2" = list(cp = c(6, 5, 8, 7, 2, 1, 4, 3), 
                            ep = c(2, 1, 4, 3, 11, 10, 9, 12, 7, 6, 5, 8), 
                            spor = c(4, 5, 3, 1, 2, 6)),
                stop("illegal move"))
  
  names(out$cp) <- c("URF", "UFL", "ULB", "UBR", "DFR", "DLF", "DBL", "DRB")
  names(out$ep) <- c("FR", "FL", "BL", "BR", "UR", "UF", "UL", "UB", "DR", "DF", "DL", "DB")
  names(out$spor) <- c("U", "R", "F", "D", "L", "B")
  class(out) <- c("cubieCubePO", "cube")
  out
}



