% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexc_alphaeweibull.R
\name{lexc_alphaeweibull}
\alias{lexc_alphaeweibull}
\title{lexc_alphaeweibull function}
\usage{
lexc_alphaeweibull(
  z_ucured = z_ucured,
  z_pcured = z_pcured,
  x = x,
  theta = theta,
  sign_delta = 1
)
}
\arguments{
\item{z_ucured}{covariates matrix acting on survival function of uncured}

\item{z_pcured}{covariates matrix acting on cure proportion.}

\item{x}{the time arguments at which to calculate the cumulative excess hazard}

\item{theta}{the parameters of the cumulative excess hazard from an exponentiated Weibull distribution}

\item{sign_delta}{only used for mixture cure rate models to specify if the
effects or minus the effects of covariates acting on uncured survival to be
considered. Default will be sign_delta = "1". The alternative is
sign_delta = "-1".}
}
\value{
An object of class \code{curesurv}.
This object is a vector containing:
}
\description{
calculates the instantaneous excess hazard from an exponentiated Weibull distribution
}
\references{
Mudholkar, G.S. and Srivastava, D.K. (1993).
Exponentiated Weibull family for analyzing bathtub failure-rate data,
IEEE Transactions on Reliability, 42, 299-302.

Mudholkar, G.S., Srivastava, D.K., and Freimer, M. (1995). The exponentiated
Weibull family: a reanalysis of the bus-motor-failure data,
Technometrics, 37, 436–445.doi:10.2307/1269735
(\href{https://www.jstor.org/stable/1269735}{jstor})
}
\keyword{internal}
\keyword{lexc_alphaeweibull}
