% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ComputeBW}
\alias{ComputeBW}
\title{Data-driven bandwidth vector}
\usage{
ComputeBW(data, x)
}
\arguments{
\item{data}{Dataframe with three variables:
\describe{
    \item{t}{Observation points t sorted in ascending order. All observations need to be positive. The total number of unique observation points equals \code{length(t)}.}
    \item{freq1}{Frequency of observation t satisfying \eqn{x \le t}.
                  The total number of observations with censoring indicator \eqn{\delta =1} equals \code{sum(freq1)}. }
    \item{freq2}{Frequency of observation t. The sample size equals \code{sum(freq2)}. If no tied observations are present in the data \code{length(t)} equals \code{sum(freq2)}. }
}}

\item{x}{numeric vector containing the points where the confidence intervals are computed.}
}
\value{
bw data-driven bandwidth vector of size \code{length(x)} containing the bandwidth value for each point in x.
}
\description{
The function ComputeBW computes the bandwidth that minimizes the pointwise Mean Squared Error using the subsampling principle in combination with undersmoothing.
}
\examples{
library(Rcpp)
library(curstatCI)

# sample size
n <- 1000

# truncated exponential distribution on (0,2)
set.seed(100)
t <- rep(NA, n)
delta <- rep(NA, n)
for(i in (1:n) ){
  x<-runif(1)
  y<--log(1-(1-exp(-2))*x)
  t[i]<-2*runif(1);
  if(y<=t[i]){ delta[i]<-1}
  else{delta[i]<-0}}

A<-cbind(t[order(t)], delta[order(t)], rep(1,n))

# x vector
grid<-seq(0.1,1.9 ,by = 0.1)

# data-driven bandwidth vector
bw <- ComputeBW(data =A, x = grid)
plot(grid, bw)

}
\references{
Groeneboom, P. and Hendrickx, K. (2017). The nonparametric bootstrap for the current status model. \url{https://arxiv.org/abs/1701.07359}
}
\seealso{
\code{vignette("curstatCI")}
}
