% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawDiagramGeneric.R
\name{drawDiagramGeneric}
\alias{drawDiagramGeneric}
\title{drawDiagramGeneric}
\usage{
drawDiagramGeneric(n, go, nogo, xmax = NULL, ymax = NULL, ylab = NULL)
}
\arguments{
\item{n}{Maximum sample size}

\item{go}{Two-column matrix detailing stopping boundaries for a go decision
or efficacy stopping, where the first column contains the number of responses and
the second column contains the corresponding number of participants so far.}

\item{nogo}{Two-column matrix detailing stopping boundaries for a no go decision
or futility stopping, where the first column contains the number of responses and
the second column contains the corresponding number of participants so far.}

\item{xmax}{Optional. Maximum value for x axis.}

\item{ymax}{Optional. Maximum value for y axis.}

\item{ylab}{Optional. Label for y axis.}
}
\value{
An object of class \code{ggplot}, showing a visualisation of the
maximum sample size and inputted stopping boundaries.
}
\description{
drawDiagramGeneric
}
\examples{
 go <- cbind(6:8, rep(8,3))
 nogo <- cbind(0:5, rep(8,6))
 drawDiagramGeneric(n=8, go=go, nogo=nogo, ylab="Number of successes")
}
\author{
Martin Law, \email{martin.law@mrc-bsu.cam.ac.uk}
}
