% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gscusum}
\alias{gscusum}
\title{Group-sequential CUSUM chart}
\usage{
gscusum(input_outcomes, failure_probability, odds_multiplier, limit,
  quantiles, max_num_shuffles = 10000L, seed = 0L)
}
\arguments{
\item{input_outcomes}{Matrix. First column are binary patient outcomes (0,1). Second column are continuous sequence of block identifier.}

\item{failure_probability}{Double. Baseline failure probability}

\item{odds_multiplier}{Double. Odds multiplier of adverse event under the alternative hypothesis (<1 looks for decreases)}

\item{limit}{Double. Control limit for signalling performance change}

\item{quantiles}{Double. Vector of requested quantiles of GSCUSUM distribution}

\item{max_num_shuffles}{Integer. Number of shuffles (i.e. different sequences of observations)}

\item{seed}{Integer. Seed for RNG (if = 0 random seed is set (default))}
}
\value{
gscusum matrix, signal probability, average CUSUM value and specified quantiles for every observation.
}
\description{
Calculate GSCUSUM chart for non-risk-adjusted processes.
}
