% Generated by roxygen2 (4.0.0): do not edit by hand
\name{Cut}
\alias{Cut}
\title{The simple version of CUTOFF}
\usage{
Cut(data, cutoff = 0.75, method = "pearson", ID = FALSE, ...)
}
\arguments{
\item{data}{a data matrix with missing values}

\item{cutoff}{the cutoff value for the CUTOFF method}

\item{method}{CUTOFF method to be used.}

\item{ID}{If the reference information needs to be retained during the imputation
if TRUE, then reference information can be retained from the returned list by
calling ID. If FALSE, then no reference information will be retained.}

\item{...}{other arguments}
}
\value{
If ID = FALSE, then return the imputed data matrix with no
missing values. If ID = TRUE, then return a list of two components:

\item{imputed}{The imputed data matrix with no missing values}
\item{ID}{The reference information during the imputation}
}
\description{
The simple version of CUTOFF
}
\examples{
data(hqmr.data)
#' # check the number of missing values
nmissing(hqmr.data[, -79])
# impute the data by the CUTOFF method
impdata <- Cut(data = hqmr.data)
nmissing(impdata)
}
\references{
Lingbing Feng, Gen Nowak, Alan. H. Welsh and Terry. J. O'Neill
(2014): CUTOFF: A Spatio-temporal Imputation Method,
\emph{Journal of Hydrology}. (submitted)
}

