% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-Deb.R
\name{DEB_Daphnia}
\alias{DEB_Daphnia}
\alias{DebDaphnia-class}
\title{DEBtox Daphnia}
\usage{
DEB_Daphnia()
}
\value{
an S4 object of type \linkS4class{DebDaphnia}
}
\description{
Creates a  \emph{DEBtox Daphnia} scemarop.
}
\details{
\subsection{State variables}{

The following list describes the default names and standard units of the
model's state variables:
\itemize{
\item \code{D}, scaled damage (\link{C})
\item \code{L}, body length (mm)
\item \code{R}, cumulative reproduction (-)
\item \code{S}, survival probability (-)
}

All state variables are initialized with zero. See \code{\link[=set_init]{set_init()}} on how to set
the initial state.
}

\subsection{Parameters}{

The following parameters are required:
\itemize{
\item General
\itemize{
\item \code{L0}, body length at start (mm)
\item \code{Lp}, body length at puberty (mm)
\item \code{Lm}, maximum body length (mm)
\item \code{rB}, von Bertalanffy growth rate constant (1/d)
\item \code{Rm}, maximum reproduction rate (#/d)
\item \code{f}, scaled functional response (-)
\item \code{hb}, background hazard rate (d-1)
}
\item Extra parameters
\itemize{
\item \code{Lf}, body length at half-saturation feeding (mm)
\item \code{Lj}, body length at which acceleration stops (mm)
\item \code{Tlag}, lag time for start development (d)
}
\item TKTD parameters
\itemize{
\item \code{kd}, dominant rate constant (d-1)
\item \code{zb}, effect threshold energy budget (\link{C})
\item \code{bb}, effect strength energy-budget effects (1/\link{C})
\item \code{zs}, effect threshold survival (\link{C})
\item \code{bs}, effect strength survival (1/(\link{C} d))
}
\item Global parameters
\itemize{
\item \code{FBV}, dry weight egg as fraction of structural body weight (-)
\item \code{KRV}, part. coeff. repro buffer and structure (kg/kg) (for losses with reproduction)
\item \code{kap}, approximation for kappa (for starvation response)
\item \code{yP}, product of yVA and yAV (for starvation response)
\item \code{Lm_ref}, reference max length for scaling rate constants (mm)
\item \code{len}, switch to fit length 1) with shrinking, 2) without shrinking
\item \code{Tbp}, brood-pouch delay (d)
}
\item \code{MoA}, mode of action switch (-)
\item \code{FB}, feedback on damage dynamics switch (-)
}
\subsection{Mode of Action}{

Any combination of the following mode of actions (MoA) can be considered by
the model:
\itemize{
\item \code{MoA = 1}: assimilation/feeding
\item \code{MoA = 2}: costs for maintenance
\item \code{MoA = 4}: costs for growth and reproduction
\item \code{MoA = 8}: costs for reproduction
\item \code{MoA = 16}: hazard for reproduction
}

To activate more than one MoA, simply add up the corresponding
codes. To disable all MoAs, set the parameter to zero. See also
\code{\link[=set_mode_of_action]{set_mode_of_action()}}.
}

\subsection{Feedbacks}{

Any combination of the following damage feedbacks can be considered by
the model:
\itemize{
\item \code{1}: surf:vol scaling uptake rate
\item \code{2}: surf:vol scaling elimination rate
\item \code{4}: growth dilution
\item \code{8}: losses with reproduction
}

To activate more than one feedback, simply add up the corresponding
codes. To disable all feedbacks, set the parameter to zero.
}

}

\subsection{Effects}{

The state variables \emph{L} (body length), \emph{R} (cumulative reproduction), and
\emph{S} (survival probability) are set as effect endpoints by default. All state
variables are available as potential endpoints. The list of considered
endpoints can be modified by using \code{\link[=set_endpoints]{set_endpoints()}}.

To calculate effects, each \emph{DEB} scenario is simulated twice: One simulation
which considers exposure to a toxicant and one simulation without exposure, i.e.
a control. See also \code{\link[=effect]{effect()}}.
}

\subsection{Output variables}{

The following intermediary model variables can be added to the model
output on demand, see \code{\link[=simulate]{simulate()}} for details:
\itemize{
\item \code{nout >= 3}
\itemize{
\item \code{f}, actual f
\item \code{fR}, actual f considering starvation
\item \code{kd}, actual kd
}
\item \code{nout >= 6}
\itemize{
\item \code{s}, stress level for metabolic effects
\item \code{sA}, stress factor on assimilation/feeding
\item \code{h}, hazard rate for effects on survival
}
\item \code{nout >= 10}, damage feedbacks
\itemize{
\item \code{xu}, factor for surf:vol scaling uptake rate
\item \code{xe}, factor for surf:vol scaling elimination rate
\item \code{xG}, factor for growth dilution
\item \code{xR}, factor for losses with repro
}
}
}
}
\seealso{
Other DEB models: 
\code{\link{DEB-models}},
\code{\link{DEB_abj}()}
}
\concept{DEB models}
