% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-algae.R
\name{Algae_Simple}
\alias{Algae_Simple}
\alias{AlgaeSimple-class}
\alias{AlgaeSimpleScenario-class}
\title{Algae model with exponential growth but without additional forcings}
\usage{
Algae_Simple()
}
\value{
an S4 object of type \linkS4class{AlgaeSimple}
}
\description{
The model is a mechanistic combined toxicokinetic-toxicodynamic (TK/TD) and
growth model for algae. It follows the concept of a simplified algae model
described in Rendal et al. (2023). The model simulates the development of
algal biomass. The growth of the algae population is simulated on the basis
of growth rates, which are, in contrast to the Weber model, independent on
environmental conditions which are usually optimal in laboratory effect studies.
The toxicodynamic sub-model describes the effects of growth-inhibiting
substances through a corresponding reduction in the photosynthesis rate on the
basis of either external or internal concentrations (depending on user choice of 'scaled' parameter setting).
}
\section{State variables}{

The model has two state variables:
\itemize{
\item \code{A}, Biomass (ug fresh wt/mL, cells/mL *10^4)
\item \code{Dw}, only used if scaled = 1
}
}

\section{Model parameters}{

\itemize{
\item Growth model
\itemize{
\item \code{mu_max}, Maximum growth rate (d-1)
}
\item Concentration response (Toxicodynamics)
\itemize{
\item \code{EC_50}, Effect concentration of 50\% inhibition of growth rate (ug L-1)
\item \code{b}, slope of concentration effect curve at EC_50 (-)
\item \code{dose_response}, shape of the dose response curve (0 = logit, 1 = probit)
}
\item External concentration (Toxicokinetics)
\itemize{
\item \code{kD}, dominant rate constant of toxicant in aquatic environments (d-1)
\item \code{scaled}, 0 = no internal scaled damage / 1 = yes (-)
}
}
}

\section{Forcings}{

Simplified model without additional forcings for e.g. irradiation or temperature
as implemented in \code{Algae_Weber}. A constant growth over time is assumed.
In case that growth is time dependent, a forcing variable (f_growth) can be set.
Forcing time-series are represented by \code{data.frame} objects consisting of two
columns. The first for time and the second for a scaling factor of mu_max.
The input format for all forcings is a list of the data frames. If f_growth is
not set, a default scaling factor of 1 is used.
}

\section{Parameter boundaries}{

Upper and lower parameter boundaries are set by default for each parameter. This,
to avoid extreme values during calibration (particularly likelihood profiling)
}

\section{Simulation output}{

Simulation results will contain the state variables biomass (\code{A}) and
scaled damage concentration (\code{Dw}).

It is possible to amend the output of \code{\link[=simulate]{simulate()}} with additional model
quantities that are not state variables, for e.g. debugging purposes or to
analyze model behavior. To enable or disable additional outputs, use the
optional argument \code{nout} of \code{\link[=simulate]{simulate()}}. As an example, set \code{nout=2} to
enable reporting of external concentration (\code{Cw}) and growth scaling factor
(\code{f_growth}). Set \code{nout=0} to disable additional outputs (default).

The available output levels are as follows:
\itemize{
\item \code{nout >= 1}: \code{Cw} external concentration (ug L-1)
\item \code{nout >= 2}: \code{f_growth} growth scaling factor (-)
\item \code{nout >= 3}: \code{dA}, biomass derivative (µg)
\item \code{nout >= 4}: \code{dDw}, damage concentration derivative (ug L-1)
}
}

\references{
Weber D, Schaeffer D, Dorgerloh M, Bruns E, Goerlitz G, Hammel K, Preuss TG
and Ratte HT, 2012. Combination of a higher-tier flow-through system and
population modeling to assess the effects of time-variable exposure of
isoproturon on the green algae Desmodesmus subspictatus and
Pseudokirchneriella subcapitata. Environmental Toxicology and
Chemistry, 31, 899-908. \doi{10.1002/etc.1765}
}
\seealso{
\link{Scenarios}, \link{Transferable}

Other algae models: 
\code{\link{Algae-models}},
\code{\link{Algae_TKTD}()},
\code{\link{Algae_Weber}()}
}
\concept{algae models}
