% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/man-macrophytes.R
\name{Macrophyte-models}
\alias{Macrophyte-models}
\title{Macrophyte models}
\description{
Population models of standard test macrophytes, such as \emph{Lemna spp.}
}
\details{
Available macrophyte models:
\itemize{
\item \link[=Lemna-models]{Lemna}
\item \link[=Myrio]{Myriophyllum}
}
}
\section{Biomass transfer}{

Models supporting biomass transfer can be instructed to move a fixed amount
of biomass to a new medium after a period of time. This feature replicates
a procedure occurring in e.g. Lemna effect studies and may be necessary to
recreate study results.

The biomass transfer feature assumes that always a fixed amount of
biomass is transferred. Transfers can occur at any fixed point in time or
in regular intervals. During a transfer, the biomass is reset to the
transferred amount and additional compartments can be scaled 1:1 accordingly,
to e.g. reflect the change in internal toxicant mass when biomass is modified.
Transfer settings can be modified using \code{\link[=set_transfer]{set_transfer()}}.

Any transfer time point must also be an output time point. If a transfer
occurs, simulation results of that time point will report the model state
\strong{before} the transfer. Be aware that in order to use transfers at regular
intervals, the simulation must start at time point zero.
}

\seealso{
\link{Scenarios}

Other macrophyte models: 
\code{\link{Lemna_SETAC}()},
\code{\link{Lemna_Schmitt}()},
\code{\link{Myrio}()},
\code{\link{Myrio_log}()}

Other models: 
\code{\link{Algae-models}},
\code{\link{DEB-models}},
\code{\link{GUTS-RED-models}},
\code{\link{Lemna-models}},
\code{\link{Myriophyllum-models}}
}
\concept{macrophyte models}
\concept{models}
