% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen.R
\name{data_gen}
\alias{data_gen}
\title{Simulated data}
\usage{
data_gen(R, K, n, M0 = 50, typ, design)
}
\arguments{
\item{R}{A scalar of value ranging from \code{0.1} to \code{0.9}. The ratio of \code{var(mu)/var(Y)}.}

\item{K}{A scalar. The number of replications.}

\item{n}{A scalar. The sample size of simulated data.}

\item{M0}{A scalar. True dimension of scalar predictors.}

\item{typ}{A scalar of value \code{1} or \code{2}. Type of the additive function for the functional predictor.}

\item{design}{A scalar of value \code{1}, \code{2}, or \code{3}. Designs 1, 2, 3 corresponding to simulation studies.}
}
\value{
A \code{list} of \code{K} simulated data sets. Each data set is of \code{matrix} type,
     whose first \code{M0} columns corresponds to the design matrix of scalar predictors, followed by the
     recording/measurement matrix of the functional predictor, and vectors \code{mu}, \code{Y}, \code{testY}.
}
\description{
Simulate sample data for illustration, including a \code{M0}-column design matrix of scalar predictors,
     a \code{100}-column matrix of the functional predictor, a one-column vector of \code{mu}, a one-column vector of \code{Y},
     and a one-column vector of \code{testY}.
}
\examples{
library(MASS)
# Example: Design 1 in simulation study
data_gen(R = 0.6, K = 2, n = 10, typ = 1, design = 1)

# Example: Design 2 in simulation study
data_gen(R = 0.3, K = 3, n = 10, typ = 2, design = 2)

# Example: Design 3 in simulation study
data_gen(R = 0.9, K = 5, n = 20, typ = 1, design = 3)


}
