% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avg_fitness_diff.R
\name{avg_fitness_diff}
\alias{avg_fitness_diff}
\title{Average fitness differences}
\usage{
avg_fitness_diff(
  cxr_multifit = NULL,
  cxr_sp1 = NULL,
  cxr_sp2 = NULL,
  pair_lambdas = NULL,
  pair_matrix = NULL,
  model_family = NULL
)
}
\arguments{
\item{cxr_multifit}{cxr_pm_multifit object, with parameters for a series of species.}

\item{cxr_sp1}{cxr_pm_fit object giving the parameters from the first species.}

\item{cxr_sp2}{cxr_pm_fit object giving the parameters from the second species.}

\item{pair_lambdas}{numeric vector of length 2 giving lambda values for the two species.}

\item{pair_matrix}{2x2 matrix with intra and interspecific interaction
coefficients between the two species.}

\item{model_family}{model family for which to calculate fitness differences.}
}
\value{
data frame with variable number of rows, and columns specifying the different components of the MCT average fitness ratio,
as well as its structural analog. The average fitness ratio informs quantitatively about the better competitor.
If the ratio is < 1, sp2 is the better competitor; if = 1, both species are equivalent competitors, if > 1, sp1 is the better competitor.
}
\description{
computes the average fitness differences among two or more species according to the formulation
of the MCT (Chesson 2012, Godoy and Levine 2014), and according to the structural approach (Saavedra et al. 2017).
For the MCT version, the average fitness ratio is decomposed in a 'demographic ratio' and a 'competitive response ratio',
the product of which is the average fitness ratio (Godoy and Levine 2014). This formulation is only valid for competitive
interaction coefficients (i.e. positive alpha values in the interaction matrix). The structural analog can be computed
for any interaction matrix, on the other hand. Note that the 'demographic ratio' is model-specific (Hart et al. 2018).
}
\details{
This function, as in \code{niche_overlap} and \code{competitive_ability}, accepts three different parameterizations:
\itemize{
\item A cxr_pm_multifit object, from which average fitness differences will be computed across all species pairs.
\item two cxr_pm_fit objects, one for each species.
\item explicit lambda and alpha values, as well as the model family from which these parameters were obtained.
}

If using the third parameterization, the function will try to find a model-specific function
for obtaining the demographic ratio, by looking at the 'model_family' parameter.
If this specific function is not found, it will resort to the standard Lotka-Volterra
formulation (lambda in the numerator term).
Overall, we strongly suggest that you use the standard formulation ONLY if you are completely confident
that your custom model is consistent with it.
Otherwise, you should include your own formulation of the demographic ratio (see vignette 4).
}
\examples{
avg_fitness_diff(pair_lambdas = runif(2,1,10),
                 pair_matrix = matrix(runif(4,0,1),nrow = 2),
                 model_family = "BH")
}
