% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyjShiny.R
\name{cyjShiny}
\alias{cyjShiny}
\title{cyjShiny
cyjShiny}
\usage{
cyjShiny(
  graph,
  layoutName,
  styleFile = NULL,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{graph}{a graph in json format; converters from graphNEL and data.frame/s offered ("see also" below)}

\item{layoutName}{character one of:"preset", "cose", "cola", "circle", "concentric", "breadthfirst", "grid", "random", "dagre", "cose-bilkent"}

\item{styleFile, }{default NULL, can name a standard javascript cytoscape.js style file}

\item{width}{integer  initial width of the widget.}

\item{height}{integer initial height of the widget.}

\item{elementId}{string the DOM id into which the widget is rendered, default NULL is best.}
}
\value{
a reference to an htmlwidget.
}
\description{
This widget wraps cytoscape.js, a full-featured Javsscript network library for visualization and analysis.
}
\examples{
tbl.nodes <- data.frame(
  id = c("A", "B", "C"),
  type = c("kinase", "TF", "glycoprotein"),
  lfc = c(-3, 1, 1),
  count = c(0, 0, 0),
  stringsAsFactors = FALSE
)

tbl.edges <- data.frame(
  source = c("A", "B", "C"),
  target = c("B", "C", "A"),
  interaction = c("phosphorylates", "synthetic lethal", "unknown"),
  stringsAsFactors = FALSE
)

  #  simple legitimate graph, nodes implied, but no node attributes
graph.json.v1 <- dataFramesToJSON(tbl.edges)
  # nodes and edges both explicit,  attributes specified
graph.json.v2 <- dataFramesToJSON(tbl.edges, tbl.nodes)

g <- graphNEL(nodes = c("A", "B", "C"), edgemode = "directed")
g <- addEdge("A", "B", g)
graph.json.v3 <- graphNELtoJSON(g)

# output$cyjShiny <- renderCyjShiny(cyjShiny(graph.json.v[123]))
}
\seealso{
\code{\link{dataFramesToJSON}}

\code{\link{graphNELtoJSON}}
}
