% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyjShiny.R
\name{setEdgeAttributes}
\alias{setEdgeAttributes}
\title{Assign the supplied edge attribute values to the graph structure contained in the browser.}
\usage{
setEdgeAttributes(
  session,
  attributeName,
  sourceNodes,
  targetNodes,
  interactions,
  values
)
}
\arguments{
\item{session}{a Shiny Server session object.}

\item{attributeName}{character string, the attribute to update.}

\item{sourceNodes}{a character vector, the names of the source nodes of the edges}

\item{targetNodes}{a character vector, the names of the target nodes of the edgees}

\item{interactions}{a character vector, further identifying the specific edge whose attributes are updated.}

\item{values}{a character, logical or numeric vector, the new values.}
}
\value{
Nothing
}
\description{
Assign the supplied edge attribute values to the graph structure contained in the browser.
}
\examples{
\dontrun{
setEdgeAttributes(session,
  attributeName = "score",
  sourceNodes = c("A", "B", "C"),
  targetNodes = c("D", "E", "A"),
  interactions = c("promotes", "promotes", "inhibits"),
  values = new.scores
)
}

}
