% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asn.R
\name{bulk_origin_asn}
\alias{bulk_origin_asn}
\title{Retrieves BGP Origin ASN info for a list of ASN ids}
\usage{
bulk_origin_asn(asns, timeout = getOption("timeout"))
}
\arguments{
\item{asns}{character vector of ASN ids (character)}

\item{timeout}{numeric: the timeout (in seconds) to be used for this connection.
Beware that some OSes may treat very large values as zero: however the
POSIX standard requires values up to 31 days to be supported.}
}
\value{
data frame of BGP Origin ASN lookup results
  \itemize{
    \item \code{as} - AS #
    \item \code{cc} - Country code
    \item \code{registry} - registry it falls under
    \item \code{allocated} - when it was allocated
    \item \code{as_name} - name associated with the allocation
  }
  If a socket connection cannot be made (i.e. a network problem on your
  end or a service/network problem on their end), all columns will be
  \code{NA}.
}
\description{
Retrieves BGP Origin ASN info for a list of ASN ids
}
\note{
The Team Cymru's service is NOT a GeoIP service! Do not use this
      function for that as your results will not be accurate.
      Data is updated every 4 hours. Also,
      A direct connection to TCP Port 43 (WHOIS) is required for most of these
      API functions to work properly.
}
\examples{
\dontrun{
bulk_origin_asn(c(22822, 1273, 2381, 2603, 2914, 3257, 3356, 11164,
                  174, 286, 1299, 2914, 3257, 3356, 3549, 22822))
}
}
\seealso{
\url{http://www.team-cymru.org/IP-ASN-mapping.html}
}

