\name{ardlBound}
\alias{ardlBound}

\title{
Implement ARDL bounds test
}
\description{
Applies ARDL bounds test with the approach of Pesaran et al. (2001).
}
\usage{
ardlBound(data = NULL, formula = NULL, case = 3, p = NULL,  
          remove = NULL, autoOrder = FALSE, HAC = FALSE,
          ic = c("AIC", "BIC", "MASE", "GMRAE"), max.p = 15, 
          max.q = 15, ECM = TRUE, stability = TRUE)         
}
\arguments{
  \item{data}{
  A \code{data.frame} including all dependent and independent series. Column names this \code{data.frame} must match the variable names in \code{formula}.
  }
  \item{formula}{A \code{formula} object showing the dependent and independent series. 
  }
  \item{case}{
  An integer up to 5 showing the case number. See details.
  }
  \item{p}{
  An integer representing the order of short-run response or a \code{data.frame} to specify a different order of short-run response for each variable.  
  }
  \item{remove}{
  A list showing the elements to be removed from the model. It includes elements \code{p} as a list and \code{q} as a vector. See details.
  }
  \item{autoOrder}{
  If \code{TRUE}, the order of ARDL will be found by the \code{ardlBounOrders} function.
  }
  \item{HAC}{
  If \code{TRUE}, the Newey-West estimate of variance-covariance function is used in testing.
  }
  \item{ic}{
  Information criterion to be used in the search for optimal orders.
  }
  \item{max.p}{
  Maximum order for the short-run coefficients.
  }
  \item{max.q}{
  Maximum auto-regressive order.
  }
  \item{ECM}{
  If \code{TRUE}, the error correction model corresponding to the \code{case} is also fitted and included in the outputs.
  }
  \item{stability}{
  If both \code{ECM} and \code{stability} are \code{TRUE}, the CUSUM, CUSUM of squares, and MOSUM charts are generated over recursive residuals using the package \code{strucchange}.
  }
}
\details{

The argument \code{case} takes the values 1 for "no intercept, no trend", 2 for "restricted intercept, no trend", 3 for "unrestricted intercept, no trend", 
4 for "unrestricted intercept, restricted trend", and 5 for "unrestricted intercept, unrestricted trend." 

If the argument \code{p} is entered as an integer, the same value is used to specify the order of short-run response for all variables.

We follow the formulation of Pesaran et al. (2001). So, the upper limit of summations in the model formulation goes up to (p-1). User should consider this while setting the value(s) of \code{p}.

The names of the element \code{p} of \code{remove} must match with those in the model. For example, to remove lags 2 and 4 of the first differences of X1 and X2 and remove the lags 2 and 5 of the dependent series, \code{remove} should be defined as \code{remove = list( p = list(dX1 = c(2,4), dX2 = c(2,4)), q = c(2,5) )}.

Breusch-Godfrey and Ljung-Box tests are applied to test against the existence of autocorrelations in residuals and Breusch-Pagan test is applied to detect heteroskedasticity in residuals as a part of the bounds testing procedure. Ramsey's RESET test is conducted for correctness of functional form of the model.

The recursive CUSUM chart is plotted by \code{epf} function from the \code{strucchange} package. The recursive CUSUM of squares plot is plotted by the \code{ardlBound} function using the recursive residuals generated by \code{recresid} function of \code{strucchange} package. The testing limits on the recursive CUSUM of squares plot are calculated as described by Brown et al. (1975) based in Table 1 of Durbin (1969). The recursive MOSUM chart is plotted when there is no NA MOSUM values are calculated.
}

\value{

\item{model}{An object including the fitted model under the null and alternative hypotheses.}

\item{F.stat}{The value of F-statistic coming out of the Wald test.}

\item{p}{p-orders in the lag structure.}

\item{k}{The number of independent series.} 

\item{bg}{Breusch-Godfrey test results. Returns \code{NULL} if skipped.}

\item{lb}{Ljung-Box test results. Returns \code{NULL} if skipped.}

\item{bp}{Breusch-Pagan test results. Returns \code{NULL} if skipped.}

\item{sp}{Shapiro-Wilk test results. Returns \code{NULL} if skipped.}

\item{ECM}{A list including the error correction series in the element \code{EC.t}, the fitted error correction model in the element \code{EC.model}, and the coefficient of error correction part in the element \code{EC.beta}.}
\item{ARDL.model}{A model object including the fitted ARDL model. Use this model object to display the long-run coefficients. To see the significance test results for the logn-run coefficients, use \code{summary()} function.}

}

\references{

R.L. Brown, J. Durbin, J. M. Evans. Techniques for testing the constancy of regression relationships over time. Journal of the Royal Statistical Society - Series B, 37, 2, 149-192.

C-S. J. Chu, K. Hornik, C-M. Kuan. MOSUM tests for parameter constancy. Biometrika, 82, 603-617, 1995.

J. Durbin. Tests for serial correlation in regression analysis based on the periodogram of Least-Squares residuals. Biometrika, 56, 1, 1-15.

P.K. Narayan. The Saving and Investment Nexus for China: Evidence from Cointegration Tests. \emph{Applied Economics} 37(17):1979-1990, 2005.

M.H. Pesaran, S. Yongcheol, R.J. Smith. Bounds testing approaches to the analysis of level relationships. \emph{Journal of Applied Econometrics} 16(3):289-326, 2001.

J.B. Ramsey. Tests for specification error in classical linear Least Squares regression analysis. Journal of the Royal Statistical Society - Series B, 31, 350-371, 1969.

J. Soren, A.Q. Philips. "pss: Perform bounds test for cointegration and perform dynamic simulations."

A. Zeileis, F. Leisch, K. Hornik, C. Kleiber. strucchange: An R package for testing for structural change in linear regression models. Journal of Statistical Software, 7, 1-38, 2002.
}

\author{
Haydar Demirhan

Maintainer: Haydar Demirhan <haydar.demirhan@rmit.edu.au>
}

\examples{
\dontrun{
data(M1Germany)
data <- M1Germany[1:144,]
model <- ardlBound(data = data , formula = logprice ~ interest + logm1 , case = 2 , p = 2)

# Let ardlBoundOrders() function find the orders
model <- ardlBound(data = data , formula = logprice ~ interest + logm1 , case = 2 , 
                    max.p = 3, max.q = 3)
}
}
