% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/generateEquations.R
\name{addObservable}
\alias{addObservable}
\title{Add observables to ODEs}
\usage{
addObservable(observable, f)
}
\arguments{
\item{observable}{named character vector. Names correspond to observable names, the chars
correspond to the observation function}

\item{f}{equation list}
}
\value{
An object of class \code{eqnList}, a named vector with the equations. Contains attributes "SMatrix"
(the stoichiometric matrix), "species" (the state names), "rates" (the rate expressions) and "description".
}
\description{
Add observables to ODEs
}
\details{
Observables are translated into an ODE and added to the list of equations
}
\examples{
reactions <- data.frame(Description = c("Activation", "Deactivation"),
                        Rate = c("act*A", "deact*pA"), A=c(-1,1), pA=c(1, -1))
f <- generateEquations(reactions)
myobs <- c(tA = "s1*(pA + A)", dA = "s2*(pA-A)")
f <- addObservable(myobs, f)
}

