% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{Pexpl}
\alias{Pexpl}
\title{Parameter transformation}
\usage{
Pexpl(trafo, parameters = NULL, attach.input = FALSE,
  condition = NULL, compile = FALSE, modelname = NULL,
  verbose = FALSE)
}
\arguments{
\item{trafo}{Named character vector. Names correspond to the parameters being fed into
the model (the inner parameters). The elements of tafo are equations that express 
the inner parameters in terms of other parameters (the outer parameters)}

\item{parameters}{Character vector. Optional. If given, the generated parameter
transformation returns values for each element in \code{parameters}. If elements of
\code{parameters} are not in \code{names(trafo)} the identity transformation is assumed.}

\item{attach.input}{attach those incoming parameters to output which are not overwritten by
the parameter transformation.}

\item{condition}{character, the condition for which the transformation is generated}

\item{compile}{Logical, compile the function (see \link{funC0})}

\item{modelname}{Character, used if \code{compile = TRUE}, sets a fixed filename for the
C file.}

\item{verbose}{Print compiler output to R command line.}
}
\value{
a function \code{p2p(p, fixed = NULL, deriv = TRUE)} representing the parameter 
transformation. Here, \code{p} is a named numeric vector with the values of the outer parameters,
\code{fixed} is a named numeric vector with values of the outer parameters being considered
as fixed (no derivatives returned) and \code{deriv} is a logical determining whether the Jacobian
of the parameter transformation is returned as attribute "deriv".
}
\description{
Parameter transformation
}
\examples{

logtrafo <- c(k1 = "exp(logk1)", k2 = "exp(logk2)", 
              A = "exp(logA)", B = "exp(logB)")
p_log <- P(logtrafo)

pars <- c(logk1 = 1, logk2 = -1, logA = 0, logB = 0)
out <- p_log(pars)
getDerivs(out)
}
\seealso{
\link{Pimpl} for implicit parameter transformations
}
