% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.clustering_part2.R
\name{manual_correction}
\alias{manual_correction}
\title{Manual correction of dPCP cluster analysis}
\usage{
manual_correction(data, filename, save.plot = FALSE, format = "png", dpi = 300)
}
\arguments{
\item{data}{an object of class \code{dPCP}, inherited from
\code{\link{dPCP}}.}

\item{filename}{character. File name (no extension) for csv and pdf files to
create on disk.}

\item{save.plot}{logical. If TRUE the plots are exported to a file.}

\item{format}{a string indicating the file format for the export.
Available formats: 'eps', 'ps', 'tex', 'pdf', 'jpeg', 'tiff', 'png',
'bmp', 'svg', 'wmf'.}

\item{dpi}{numeric. Image resolution.}
}
\value{
A Shiny session.
}
\description{
This function builds an interactive app to manually correct the dPCP
cluster analysis.
}
\examples{
\donttest{
library(dPCP)

#Find path of sample table and location of reference and input files
sampleTable <- system.file("extdata", "Template_sampleTable.csv",
                     package = "dPCP")

fileLoc <- system.file("extdata",package = "dPCP")

#dPCP analysis
results <- dPCP(sampleTable, system = "bio-rad", file.location = fileLoc,
                eps = 200, minPts = 50, save.template = FALSE,
                rain = TRUE)

manual_correction(results, filename = "manual_dPCR", save.plot = FALSE)
}
}
