% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_clustering.R
\name{dtbm}
\alias{dtbm}
\title{Multiway spherical clustering for degree-corrected tensor block model}
\usage{
dtbm(Y, r, max_iter, alpha1 = 0.01, asymm)
}
\arguments{
\item{Y}{array/matrix, order-3 tensor/matrix observation}

\item{r}{vector, the cluster number on each mode; see "details"}

\item{max_iter}{integer, max number of iterations if update does not converge}

\item{alpha1}{number, substitution of degenerate core tensor; see "details"}

\item{asymm}{logic variable, if "TRUE", assume the clustering assignment differs in different modes; if "FALSE", assume all the modes share the same clustering assignment}
}
\value{
a list containing the following:

\code{z} {a list of vectors recording the refined clustering assignment with initialization \code{z0}}

\code{s_deg} {logic variable, if "TRUE", degenerate estimated core tensor/matrix occurs during the iteration; if "FALSE", otherwise}

\code{z0} { a list of vectors recording the initial clustering assignment }

\code{s0} { a list of vectors recording the index of degenerate entities with random clustering assignment in initialization}
}
\description{
Multiway spherical clustering for degree-corrected tensor block model including weighted higher-order initialization
and angle-based iteration. Main function in the package. This function takes the tensor/matrix observation,  the cluster number, and a logic variable indicating the symmetry
as input. Output contains initial and refined clustering assignment.
}
\details{
\code{r} should be a length 2 vector for matrix and length 3 vector for tensor observation;

all the elements in \code{r} should be integer larger than 1;

symmetric case only allow \code{r} with the same cluster number on each mode;

observations with non-identical dimension on each mode are only applicable with \code{asymm = T}.

When the estimated core tensor has a degenerate slice during iteration, i.e., a slice with all zero elements, randomly pick an entry in the degenerate slice with value \code{alpha1}.
}
\examples{
test_data = sim_dTBM(seed = 1, imat = FALSE, asymm = FALSE, p = c(50,50,50), r = c(3,3,3),
                    core_control = "control", s_min = 0.05, s_max = 1,
                    dist = "normal", sigma = 0.5,
                    theta_dist = "pareto", alpha = 4, beta = 3/4)

result = dtbm(test_data$Y, r = c(3,3,3), max_iter = 20, asymm = FALSE)
}
