% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_output.R
\name{build_block_df}
\alias{build_block_df}
\title{Build block dataframe}
\usage{
build_block_df(type, output)
}
\arguments{
\item{type}{one of "sync" or "async" depending on
the function used to process the original document.}

\item{output}{either a HTTP response object (from \code{dai_sync()}) or
the path to a JSON file (from \code{dai_async}).}
}
\value{
a block data frame
}
\description{
Creates a dataframe with the block bounding boxes
identified by Document AI (DAI) in an asynchronous request.
Rows are blocks, in the order DAI proposes to read them. Columns
are location variables such as page coordinates and page numbers.
}
\details{
The dataframe variables are: page number, block number,
confidence score, left boundary, right boundary, top boundary,
and bottom boundary.
}
\examples{
\dontrun{
block_df <- build_block_df(type = "async", output = "pdf_output.json")
resp <- dai_sync("file.pdf")
block_df <- build_block_df(type = "sync", output = resp)
}
}
