% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_data.R
\name{aggregate_data}
\alias{aggregate_data}
\title{Aggregate source data}
\usage{
aggregate_data(source_data, aggregation_timeunit = "day", show_progress = TRUE)
}
\arguments{
\item{source_data}{A \code{daiquiri_source_data} object returned from
\code{\link[=prepare_data]{prepare_data()}} function}

\item{aggregation_timeunit}{Unit of time to aggregate over. Specify one of
\code{"day"}, \code{"week"}, \code{"month"}, \code{"quarter"}, \code{"year"}. The \code{"week"} option is
Monday-based. Default = \code{"day"}}

\item{show_progress}{Print progress to console. Default = \code{TRUE}}
}
\value{
A \code{daiquiri_aggregated_data} object
}
\description{
Aggregates a \code{daiquiri_source_data} object based on the \code{\link[=field_types]{field_types()}} specified at load time.
Default time period for aggregation is a calendar day
}
\examples{
# load example data into a data.frame
raw_data <- read_data(
  system.file("extdata", "example_prescriptions.csv", package = "daiquiri"),
  delim = ",",
  col_names = TRUE
)

# validate and prepare the data for aggregation
source_data <- prepare_data(
  raw_data,
  field_types = field_types(
    PrescriptionID = ft_uniqueidentifier(),
    PrescriptionDate = ft_timepoint(),
    AdmissionDate = ft_datetime(includes_time = FALSE),
    Drug = ft_freetext(),
    Dose = ft_numeric(),
    DoseUnit = ft_categorical(),
    PatientID = ft_ignore(),
    Location = ft_categorical(aggregate_by_each_category = TRUE)
  ),
  override_column_names = FALSE,
  na = c("", "NULL")
)

# aggregate the data
aggregated_data <- aggregate_data(
  source_data,
  aggregation_timeunit = "day"
)

aggregated_data
}
\seealso{
\code{\link[=prepare_data]{prepare_data()}}, \code{\link[=report_data]{report_data()}}
}
