% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_psa_samp.R
\name{beta_params}
\alias{beta_params}
\title{Calculate alpha and beta parameters of beta distribution.}
\usage{
beta_params(mean, sigma)
}
\arguments{
\item{mean}{mean of the random variable.}

\item{sigma}{standard deviation of the random variable (i.e., standard error).}
}
\value{
a list containing the following:

alpha The method-of-moments estimate for the alpha parameter of the beta distribution

beta The method-of-moments estimate for the beta parameter of the beta distribution
}
\description{
Function to calculate the alpha and beta parameters of the beta distribution
based on the method of moments using the mean \eqn{\mu} and standard
deviation \eqn{\sigma} of the random variable of interest.
}
\section{Details}{

Based on methods of moments. If \eqn{\mu} is the mean and
\eqn{\sigma} is the standard deviation of the random variable, then
\deqn{\alpha = (\frac{1-\mu}{\sigma^2} - \frac{1}{\mu}) \mu^2}
and
\deqn{\beta = \alpha (\frac{1}{\mu} -1)}
}

\keyword{beta}
\keyword{distribution;}
\keyword{methods}
\keyword{moments}
\keyword{of}
