% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dap.R
\name{dap}
\alias{dap}
\alias{dapc}
\alias{dapr}
\alias{dapc_if}
\alias{dapr_if}
\title{dap: Data frame apply functions}
\usage{
dapc(.data, .f, ...)

dapr(.data, .f, ...)

dapc_if(.data, .predicate, .f, ...)

dapr_if(.data, .predicate, .f, ...)
}
\arguments{
\item{.data}{Data frame input.}

\item{.f}{Function to apply to element (columns or rows). This can be written
as a single function name e.g., \code{mean}, a formula-like function call
where '.x' is assumed to be the iterated over element of input data e.g.,
\code{~ mean(.x)}, or an in-line function definition e.g.,
\code{function(x) mean(x)}.}

\item{...}{Other values passed to function call.}

\item{.predicate}{Logical vector or expression evaluating to a logical vector.
  If not a logical vector, this can be written as a single function name
  e.g., \code{is.numeric}, a formula-like function call where '.x' is assumed
  to be the iterated over element of input data e.g.,
  \code{~ is.numeric(.x)}, or an in-line function definition e.g.,
  \code{function(x) is.numeric(x)}. Regardless, if a logical vector is not
  provided, this expression must return a logical vector of the same length
  as the input .data object.

  The resulting logical vector is used to determine which elements (rows or
  columns) to iterate over with the .f function/expression.}
}
\value{
A data frame
}
\description{
Functions that apply expressions to input data objects and return data
frames.

dapc: Apply function to columns of a data frame.

dapr: Apply function to rows of a data frame.

dapc_if: Apply function to certain columns of a data frame.

dapr_if: Apply function to certain rows of a data frame.
}
\seealso{
\code{\link{lap}} \code{\link{vap}}
}
\concept{dap}
