% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbmUnitFunctions.R
\name{tanhUnitRbm}
\alias{tanhUnitRbm}
\title{Calculates the neuron output with the hyperbolic tangent function}
\usage{
tanhUnitRbm(rbm, data, biases, weights, runParams,
  matMult = getParameter(".matMult", ...), ...)
}
\arguments{
\item{rbm}{A instance of the class \code{\linkS4class{RBM}}.}

\item{data}{A matrix with the data for the calculations.}

\item{biases}{The biases for the calculations.}

\item{weights}{The weight matrix for the calculations.}

\item{runParams}{Parameters which indicates the status of the training.}

\item{matMult}{Matrix multiplication function.}

\item{...}{Additional parameters, used for parameter resolution.}
}
\value{
The real value and binary (-1,1) activations for the units.
}
\description{
Calculates the neuron output with the hyperbolic tangent function from
input in \code{data}.
}
\details{
The return value is a list with the output of the hyperbolic
tangent function as first entry and binary (-1,1) representation calculated
through a comparison ofthe output with random numbers. The random numbers a
generated with the function \code{\link{runif}}.
}
\seealso{
Other RBM unit functions: \code{\link{linearUnitRbm}},
  \code{\link{sigmoidUnitRbm}}
}
\keyword{internal}

